/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.autoconfigure;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.autoconfigure.AbstractCircuitBreakerConfigurationOnMissingBean;
import io.github.resilience4j.circuitbreaker.configure.CircuitBreakerConfigurationProperties;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerEvent;
import io.github.resilience4j.circuitbreaker.monitoring.health.CircuitBreakerHealthIndicator;
import io.github.resilience4j.common.circuitbreaker.configuration.CircuitBreakerConfigurationProperties;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import java.util.Map;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicatorRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CircuitBreakerConfigurationOnMissingBean
extends AbstractCircuitBreakerConfigurationOnMissingBean
implements ApplicationContextAware {
    private final ConfigurableBeanFactory beanFactory;
    private ApplicationContext applicationContext;
    private HealthIndicatorRegistry healthIndicatorRegistry;

    public CircuitBreakerConfigurationOnMissingBean(CircuitBreakerConfigurationProperties circuitBreakerProperties, ConfigurableBeanFactory beanFactory) {
        super(circuitBreakerProperties);
        this.beanFactory = beanFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Bean
    @ConditionalOnMissingBean(value={CircuitBreakerEvent.class}, parameterizedContainer={EventConsumerRegistry.class})
    public EventConsumerRegistry<CircuitBreakerEvent> eventConsumerRegistry() {
        return this.circuitBreakerConfiguration.eventConsumerRegistry();
    }

    protected void createHealthIndicatorForCircuitBreaker(CircuitBreaker circuitBreaker, CircuitBreakerConfigurationProperties circuitBreakerProperties) {
        boolean registerHealthIndicator = circuitBreakerProperties.findCircuitBreakerProperties(circuitBreaker.getName()).map(CircuitBreakerConfigurationProperties.InstanceProperties::getRegisterHealthIndicator).orElse(true);
        if (registerHealthIndicator) {
            Map healthRegistryBeans;
            CircuitBreakerHealthIndicator healthIndicator = new CircuitBreakerHealthIndicator(circuitBreaker);
            String circuitBreakerName = circuitBreaker.getName() + "CircuitBreaker";
            this.beanFactory.registerSingleton(circuitBreakerName + "HealthIndicator", (Object)healthIndicator);
            if (this.applicationContext != null && this.healthIndicatorRegistry == null && (healthRegistryBeans = this.applicationContext.getBeansOfType(HealthIndicatorRegistry.class)).size() > 0) {
                this.healthIndicatorRegistry = (HealthIndicatorRegistry)healthRegistryBeans.values().iterator().next();
            }
            if (this.healthIndicatorRegistry != null && this.healthIndicatorRegistry.get(circuitBreakerName) == null) {
                this.healthIndicatorRegistry.register(circuitBreakerName, (HealthIndicator)healthIndicator);
            }
        }
    }
}

