/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.monitoring.endpoint;

import io.github.resilience4j.consumer.CircularEventConsumer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.ratelimiter.event.RateLimiterEvent;
import io.github.resilience4j.ratelimiter.monitoring.endpoint.RateLimiterEventDTO;
import io.github.resilience4j.ratelimiter.monitoring.endpoint.RateLimiterEventsEndpointResponse;
import io.vavr.collection.List;
import java.util.Comparator;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="ratelimiterevents")
public class RateLimiterEventsEndpoint {
    private final EventConsumerRegistry<RateLimiterEvent> eventsConsumerRegistry;

    public RateLimiterEventsEndpoint(EventConsumerRegistry<RateLimiterEvent> eventsConsumerRegistry) {
        this.eventsConsumerRegistry = eventsConsumerRegistry;
    }

    @ReadOperation
    public RateLimiterEventsEndpointResponse getAllRateLimiterEvents() {
        return new RateLimiterEventsEndpointResponse(this.eventsConsumerRegistry.getAllEventConsumer().flatMap(CircularEventConsumer::getBufferedEvents).sorted(Comparator.comparing(RateLimiterEvent::getCreationTime)).map(RateLimiterEventDTO::createRateLimiterEventDTO).toJavaList());
    }

    @ReadOperation
    public RateLimiterEventsEndpointResponse getEventsFilteredByRateLimiterName(@Selector String name) {
        return new RateLimiterEventsEndpointResponse(this.getRateLimiterEvents(name).map(RateLimiterEventDTO::createRateLimiterEventDTO).toJavaList());
    }

    @ReadOperation
    public RateLimiterEventsEndpointResponse getEventsFilteredByRateLimiterNameAndEventType(@Selector String name, @Selector String eventType) {
        RateLimiterEvent.Type targetType = RateLimiterEvent.Type.valueOf((String)eventType.toUpperCase());
        return new RateLimiterEventsEndpointResponse(this.getRateLimiterEvents(name).filter(event -> event.getEventType() == targetType).map(RateLimiterEventDTO::createRateLimiterEventDTO).toJavaList());
    }

    private List<RateLimiterEvent> getRateLimiterEvents(String name) {
        CircularEventConsumer eventConsumer = this.eventsConsumerRegistry.getEventConsumer(name);
        if (eventConsumer != null) {
            return eventConsumer.getBufferedEvents().filter(event -> event.getRateLimiterName().equals(name));
        }
        return List.empty();
    }
}

