/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.autoconfigure;

import io.github.resilience4j.micrometer.RetryMetrics;
import io.github.resilience4j.micrometer.tagged.TaggedRetryMetrics;
import io.github.resilience4j.retry.RetryRegistry;
import io.github.resilience4j.retry.autoconfigure.RetryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MetricsAutoConfiguration.class})
@AutoConfigureAfter(value={RetryAutoConfiguration.class, MetricsAutoConfiguration.class})
@ConditionalOnProperty(value={"resilience4j.retry.metrics.enabled"}, matchIfMissing=true)
public class RetryMetricsAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"resilience4j.retry.metrics.use_legacy_binder"}, havingValue="true")
    public RetryMetrics registerLegacyRetryMetrics(RetryRegistry retryRegistry) {
        return RetryMetrics.ofRetryRegistry((RetryRegistry)retryRegistry);
    }

    @Bean
    @ConditionalOnProperty(value={"resilience4j.retry.metrics.use_legacy_binder"}, havingValue="false", matchIfMissing=true)
    public TaggedRetryMetrics registerRetryMetrics(RetryRegistry retryRegistry) {
        return TaggedRetryMetrics.ofRetryRegistry((RetryRegistry)retryRegistry);
    }
}

