/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.autoconfigure;

import io.github.resilience4j.circuitbreaker.autoconfigure.CircuitBreakerAutoConfiguration;
import io.github.resilience4j.micrometer.RateLimiterMetrics;
import io.github.resilience4j.micrometer.tagged.TaggedRateLimiterMetrics;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MetricsAutoConfiguration.class})
@AutoConfigureAfter(value={CircuitBreakerAutoConfiguration.class, MetricsAutoConfiguration.class})
@ConditionalOnProperty(value={"resilience4j.ratelimiter.metrics.enabled"}, matchIfMissing=true)
public class RateLimiterMetricsAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"resilience4j.ratelimiter.metrics.use_legacy_binder"}, havingValue="true")
    public RateLimiterMetrics registerLegacyRateLimiterMetrics(RateLimiterRegistry rateLimiterRegistry) {
        return RateLimiterMetrics.ofRateLimiterRegistry((RateLimiterRegistry)rateLimiterRegistry);
    }

    @Bean
    @ConditionalOnProperty(value={"resilience4j.ratelimiter.metrics.use_legacy_binder"}, havingValue="false", matchIfMissing=true)
    public TaggedRateLimiterMetrics registerRateLimiterMetrics(RateLimiterRegistry rateLimiterRegistry) {
        return TaggedRateLimiterMetrics.ofRateLimiterRegistry((RateLimiterRegistry)rateLimiterRegistry);
    }
}

