/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.autoconfigure;

import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.ratelimiter.autoconfigure.RateLimiterProperties;
import io.github.resilience4j.ratelimiter.configure.RateLimiterConfiguration;
import io.github.resilience4j.ratelimiter.event.RateLimiterEvent;
import io.github.resilience4j.ratelimiter.monitoring.endpoint.RateLimiterEndpoint;
import io.github.resilience4j.ratelimiter.monitoring.endpoint.RateLimiterEventsEndpoint;
import io.github.resilience4j.ratelimiter.monitoring.health.RateLimiterHealthIndicator;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={RateLimiter.class})
@EnableConfigurationProperties(value={RateLimiterProperties.class})
@Import(value={RateLimiterConfiguration.class})
@AutoConfigureBefore(value={EndpointAutoConfiguration.class})
public class RateLimiterAutoConfiguration {
    private final RateLimiterProperties rateLimiterProperties;
    private final RateLimiterRegistry rateLimiterRegistry;
    private final ConfigurableBeanFactory beanFactory;

    public RateLimiterAutoConfiguration(RateLimiterProperties rateLimiterProperties, RateLimiterRegistry rateLimiterRegistry, ConfigurableBeanFactory beanFactory) {
        this.rateLimiterProperties = rateLimiterProperties;
        this.rateLimiterRegistry = rateLimiterRegistry;
        this.beanFactory = beanFactory;
    }

    @Bean
    @ConditionalOnEnabledEndpoint
    public RateLimiterEndpoint rateLimiterEndpoint(RateLimiterRegistry rateLimiterRegistry) {
        return new RateLimiterEndpoint(rateLimiterRegistry);
    }

    @Bean
    @ConditionalOnEnabledEndpoint
    public RateLimiterEventsEndpoint rateLimiterEventsEndpoint(EventConsumerRegistry<RateLimiterEvent> eventConsumerRegistry) {
        return new RateLimiterEventsEndpoint(eventConsumerRegistry);
    }

    @PostConstruct
    public void configureHealthIndicators() {
        this.rateLimiterProperties.getLimiters().forEach((name, properties) -> {
            if (properties.getRegisterHealthIndicator().booleanValue()) {
                this.createHealthIndicatorForLimiter((String)name);
            }
        });
    }

    private void createHealthIndicatorForLimiter(String name) {
        RateLimiter rateLimiter = this.rateLimiterRegistry.rateLimiter(name);
        this.beanFactory.registerSingleton(name + "RateLimiterHealthIndicator", (Object)new RateLimiterHealthIndicator(rateLimiter));
    }
}

