/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.autoconfigure;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import io.github.resilience4j.circuitbreaker.autoconfigure.CircuitBreakerProperties;
import io.github.resilience4j.circuitbreaker.configure.CircuitBreakerConfiguration;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerEvent;
import io.github.resilience4j.circuitbreaker.monitoring.endpoint.CircuitBreakerEndpoint;
import io.github.resilience4j.circuitbreaker.monitoring.endpoint.CircuitBreakerEventsEndpoint;
import io.github.resilience4j.circuitbreaker.monitoring.health.CircuitBreakerHealthIndicator;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={CircuitBreaker.class})
@EnableConfigurationProperties(value={CircuitBreakerProperties.class})
@Import(value={CircuitBreakerConfiguration.class})
@AutoConfigureBefore(value={EndpointAutoConfiguration.class})
public class CircuitBreakerAutoConfiguration {
    private final CircuitBreakerProperties circuitBreakerProperties;
    private final CircuitBreakerRegistry circuitBreakerRegistry;
    private final ConfigurableBeanFactory beanFactory;

    public CircuitBreakerAutoConfiguration(CircuitBreakerProperties circuitBreakerProperties, CircuitBreakerRegistry circuitBreakerRegistry, ConfigurableBeanFactory beanFactory) {
        this.circuitBreakerProperties = circuitBreakerProperties;
        this.circuitBreakerRegistry = circuitBreakerRegistry;
        this.beanFactory = beanFactory;
    }

    @Bean
    @ConditionalOnEnabledEndpoint
    public CircuitBreakerEndpoint circuitBreakerEndpoint(CircuitBreakerRegistry circuitBreakerRegistry) {
        return new CircuitBreakerEndpoint(circuitBreakerRegistry);
    }

    @Bean
    @ConditionalOnEnabledEndpoint
    public CircuitBreakerEventsEndpoint circuitBreakerEventsEndpoint(EventConsumerRegistry<CircuitBreakerEvent> eventConsumerRegistry) {
        return new CircuitBreakerEventsEndpoint(eventConsumerRegistry);
    }

    @PostConstruct
    public void configureRegistryWithHealthEndpoint() {
        this.circuitBreakerProperties.getBackends().forEach((name, properties) -> {
            if (properties.getRegisterHealthIndicator().booleanValue()) {
                this.createHeathIndicatorForCircuitBreaker((String)name);
            }
        });
    }

    private void createHeathIndicatorForCircuitBreaker(String name) {
        CircuitBreaker circuitBreaker = this.circuitBreakerRegistry.circuitBreaker(name);
        CircuitBreakerHealthIndicator healthIndicator = new CircuitBreakerHealthIndicator(circuitBreaker);
        this.beanFactory.registerSingleton(name + "CircuitBreakerHealthIndicator", (Object)healthIndicator);
    }
}

