/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.monitoring.endpoint;

import io.github.resilience4j.consumer.CircularEventConsumer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.ratelimiter.event.RateLimiterEvent;
import io.github.resilience4j.ratelimiter.monitoring.model.RateLimiterEventDTO;
import io.github.resilience4j.ratelimiter.monitoring.model.RateLimiterEventsEndpointResponse;
import java.util.Comparator;
import java.util.List;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="ratelimiter-events")
public class RateLimiterEventsEndpoint {
    private final EventConsumerRegistry<RateLimiterEvent> eventsConsumerRegistry;

    public RateLimiterEventsEndpoint(EventConsumerRegistry<RateLimiterEvent> eventsConsumerRegistry) {
        this.eventsConsumerRegistry = eventsConsumerRegistry;
    }

    @ReadOperation
    public RateLimiterEventsEndpointResponse getAllRateLimiterEvents() {
        List eventsList = this.eventsConsumerRegistry.getAllEventConsumer().flatMap(CircularEventConsumer::getBufferedEvents).sorted(Comparator.comparing(RateLimiterEvent::getCreationTime)).map(RateLimiterEventDTO::createRateLimiterEventDTO).toJavaList();
        return new RateLimiterEventsEndpointResponse(eventsList);
    }

    @ReadOperation
    public RateLimiterEventsEndpointResponse getEventsFilteredByRateLimiterName(@Selector String name) {
        List eventsList = this.eventsConsumerRegistry.getEventConsumer(name).getBufferedEvents().filter(event -> event.getRateLimiterName().equals(name)).map(RateLimiterEventDTO::createRateLimiterEventDTO).toJavaList();
        return new RateLimiterEventsEndpointResponse(eventsList);
    }

    @ReadOperation
    public RateLimiterEventsEndpointResponse getEventsFilteredByRateLimiterNameAndEventType(@Selector String name, @Selector String eventType) {
        RateLimiterEvent.Type targetType = RateLimiterEvent.Type.valueOf((String)eventType.toUpperCase());
        List eventsList = this.eventsConsumerRegistry.getEventConsumer(name).getBufferedEvents().filter(event -> event.getRateLimiterName().equals(name)).filter(event -> event.getEventType() == targetType).map(RateLimiterEventDTO::createRateLimiterEventDTO).toJavaList();
        return new RateLimiterEventsEndpointResponse(eventsList);
    }
}

