/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.monitoring.health;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.internal.AtomicRateLimiter;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;

public class RateLimiterHealthIndicator
implements HealthIndicator {
    private final RateLimiter rateLimiter;
    private final long timeoutInNanos;

    public RateLimiterHealthIndicator(RateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
        this.timeoutInNanos = rateLimiter.getRateLimiterConfig().getTimeoutDuration().toNanos();
    }

    public Health health() {
        AtomicRateLimiter atomicRateLimiter;
        AtomicRateLimiter.AtomicRateLimiterMetrics detailedMetrics;
        RateLimiter.Metrics metrics = this.rateLimiter.getMetrics();
        int availablePermissions = metrics.getAvailablePermissions();
        int numberOfWaitingThreads = metrics.getNumberOfWaitingThreads();
        if (availablePermissions > 0 || numberOfWaitingThreads == 0) {
            return this.rateLimiterHealth(Status.UP, availablePermissions, numberOfWaitingThreads);
        }
        if (this.rateLimiter instanceof AtomicRateLimiter && (detailedMetrics = (atomicRateLimiter = (AtomicRateLimiter)this.rateLimiter).getDetailedMetrics()).getNanosToWait() > this.timeoutInNanos) {
            return this.rateLimiterHealth(Status.DOWN, availablePermissions, numberOfWaitingThreads);
        }
        return this.rateLimiterHealth(Status.UNKNOWN, availablePermissions, numberOfWaitingThreads);
    }

    private Health rateLimiterHealth(Status status, int availablePermissions, int numberOfWaitingThreads) {
        return Health.status((Status)status).withDetail("availablePermissions", (Object)availablePermissions).withDetail("numberOfWaitingThreads", (Object)numberOfWaitingThreads).build();
    }
}

