/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.transformer;

import io.github.resilience4j.AbstractSingleObserver;
import io.github.resilience4j.micrometer.Timer;
import io.reactivex.Single;
import io.reactivex.SingleObserver;

class SingleTimer<T>
extends Single<T> {
    private final Timer timer;
    private final Single<T> upstream;

    SingleTimer(Single<T> upstream, Timer timer) {
        this.upstream = upstream;
        this.timer = timer;
    }

    protected void subscribeActual(SingleObserver<? super T> downstream) {
        this.upstream.subscribe((SingleObserver)new TimerSingleObserver(downstream, this.timer));
    }

    class TimerSingleObserver
    extends AbstractSingleObserver<T> {
        private final Timer.Context context;

        TimerSingleObserver(SingleObserver<? super T> downstreamObserver, Timer timer) {
            super(downstreamObserver);
            this.context = timer.createContext();
        }

        @Override
        protected void hookOnError(Throwable e) {
            this.context.onFailure(e);
        }

        @Override
        protected void hookOnSuccess(T value) {
            this.context.onSuccess();
        }

        @Override
        protected void hookOnCancel() {
            this.context.onSuccess();
        }
    }
}

