/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.transformer;

import io.github.resilience4j.AbstractObserver;
import io.github.resilience4j.micrometer.Timer;
import io.reactivex.Observable;
import io.reactivex.Observer;

class ObservableTimer<T>
extends Observable<T> {
    private final Observable<T> upstream;
    private final Timer timer;

    ObservableTimer(Observable<T> upstream, Timer timer) {
        this.upstream = upstream;
        this.timer = timer;
    }

    protected void subscribeActual(Observer<? super T> downstream) {
        this.upstream.subscribe((Observer)new TimerObserver(downstream, this.timer));
    }

    class TimerObserver
    extends AbstractObserver<T> {
        private final Timer.Context context;

        TimerObserver(Observer<? super T> downstreamObserver, Timer timer) {
            super(downstreamObserver);
            this.context = timer.createContext();
        }

        @Override
        protected void hookOnError(Throwable e) {
            this.context.onFailure(e);
        }

        @Override
        protected void hookOnComplete() {
            this.context.onSuccess();
        }

        @Override
        protected void hookOnCancel() {
            this.context.onSuccess();
        }
    }
}

