/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.operator;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.operator.CompletableRateLimiter;
import io.github.resilience4j.ratelimiter.operator.FlowableRateLimiter;
import io.github.resilience4j.ratelimiter.operator.MaybeRateLimiter;
import io.github.resilience4j.ratelimiter.operator.ObserverRateLimiter;
import io.github.resilience4j.ratelimiter.operator.SingleRateLimiter;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.CompletableTransformer;
import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.MaybeTransformer;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.SingleTransformer;
import java.util.Objects;
import org.reactivestreams.Publisher;

public class RateLimiterOperator<T>
implements FlowableTransformer<T, T>,
SingleTransformer<T, T>,
MaybeTransformer<T, T>,
CompletableTransformer,
ObservableTransformer<T, T> {
    private final RateLimiter rateLimiter;

    public static <T> RateLimiterOperator<T> of(RateLimiter rateLimiter) {
        return new RateLimiterOperator<T>(rateLimiter);
    }

    private RateLimiterOperator(RateLimiter rateLimiter) {
        this.rateLimiter = Objects.requireNonNull(rateLimiter);
    }

    public Publisher<T> apply(Flowable<T> upstream) {
        return new FlowableRateLimiter<T>(upstream, this.rateLimiter);
    }

    public SingleSource<T> apply(Single<T> upstream) {
        return new SingleRateLimiter<T>(upstream, this.rateLimiter);
    }

    public CompletableSource apply(Completable upstream) {
        return new CompletableRateLimiter(upstream, this.rateLimiter);
    }

    public MaybeSource<T> apply(Maybe<T> upstream) {
        return new MaybeRateLimiter<T>(upstream, this.rateLimiter);
    }

    public ObservableSource<T> apply(Observable<T> upstream) {
        return new ObserverRateLimiter<T>(upstream, this.rateLimiter);
    }
}

