/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.circuitbreaker.operator;

import io.github.resilience4j.AbstractCompletableObserver;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;
import java.util.concurrent.TimeUnit;

class CompletableCircuitBreaker
extends Completable {
    private final Completable upstream;
    private final CircuitBreaker circuitBreaker;

    CompletableCircuitBreaker(Completable upstream, CircuitBreaker circuitBreaker) {
        this.upstream = upstream;
        this.circuitBreaker = circuitBreaker;
    }

    protected void subscribeActual(CompletableObserver downstream) {
        if (this.circuitBreaker.tryAcquirePermission()) {
            this.upstream.subscribe((CompletableObserver)new CircuitBreakerCompletableObserver(downstream));
        } else {
            downstream.onSubscribe((Disposable)EmptyDisposable.INSTANCE);
            downstream.onError((Throwable)new CallNotPermittedException(this.circuitBreaker));
        }
    }

    class CircuitBreakerCompletableObserver
    extends AbstractCompletableObserver {
        private final long start;

        CircuitBreakerCompletableObserver(CompletableObserver downstreamObserver) {
            super(downstreamObserver);
            this.start = System.nanoTime();
        }

        @Override
        protected void hookOnComplete() {
            CompletableCircuitBreaker.this.circuitBreaker.onSuccess(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
        }

        @Override
        protected void hookOnError(Throwable e) {
            CompletableCircuitBreaker.this.circuitBreaker.onError(System.nanoTime() - this.start, TimeUnit.NANOSECONDS, e);
        }

        @Override
        protected void hookOnCancel() {
            CompletableCircuitBreaker.this.circuitBreaker.releasePermission();
        }
    }
}

