/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j;

import io.github.resilience4j.AbstractDisposable;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import java.util.Objects;

public abstract class AbstractSingleObserver<T>
extends AbstractDisposable
implements SingleObserver<T> {
    private final SingleObserver<? super T> downstreamObserver;

    public AbstractSingleObserver(SingleObserver<? super T> downstreamObserver) {
        this.downstreamObserver = Objects.requireNonNull(downstreamObserver);
    }

    @Override
    protected void hookOnSubscribe() {
        this.downstreamObserver.onSubscribe((Disposable)this);
    }

    public void onError(Throwable e) {
        this.whenNotCompleted(() -> {
            this.hookOnError(e);
            this.downstreamObserver.onError(e);
        });
    }

    protected abstract void hookOnError(Throwable var1);

    public void onSuccess(T value) {
        this.whenNotCompleted(() -> {
            this.hookOnSuccess();
            this.downstreamObserver.onSuccess(value);
        });
    }

    protected abstract void hookOnSuccess();
}

