/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.operator;

import io.github.resilience4j.AbstractSingleObserver;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;

class SingleBulkhead<T>
extends Single<T> {
    private final Bulkhead bulkhead;
    private final Single<T> upstream;

    SingleBulkhead(Single<T> upstream, Bulkhead bulkhead) {
        this.upstream = upstream;
        this.bulkhead = bulkhead;
    }

    protected void subscribeActual(SingleObserver<? super T> downstream) {
        if (this.bulkhead.tryAcquirePermission()) {
            this.upstream.subscribe((SingleObserver)new BulkheadSingleObserver(downstream));
        } else {
            downstream.onSubscribe((Disposable)EmptyDisposable.INSTANCE);
            downstream.onError((Throwable)new BulkheadFullException(this.bulkhead));
        }
    }

    class BulkheadSingleObserver
    extends AbstractSingleObserver<T> {
        BulkheadSingleObserver(SingleObserver<? super T> downstreamObserver) {
            super(downstreamObserver);
        }

        @Override
        protected void hookOnError(Throwable e) {
            SingleBulkhead.this.bulkhead.onComplete();
        }

        @Override
        protected void hookOnSuccess() {
            SingleBulkhead.this.bulkhead.onComplete();
        }

        @Override
        protected void hookOnCancel() {
            SingleBulkhead.this.bulkhead.releasePermission();
        }
    }
}

