/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.operator;

import io.github.resilience4j.AbstractSubscriber;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.reactivex.Flowable;
import io.reactivex.internal.subscriptions.EmptySubscription;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class FlowableBulkhead<T>
extends Flowable<T> {
    private final Bulkhead bulkhead;
    private final Publisher<T> upstream;

    FlowableBulkhead(Publisher<T> upstream, Bulkhead bulkhead) {
        this.bulkhead = Objects.requireNonNull(bulkhead);
        this.upstream = Objects.requireNonNull(upstream, "source is null");
    }

    protected void subscribeActual(Subscriber<? super T> downstream) {
        if (this.bulkhead.tryAcquirePermission()) {
            this.upstream.subscribe((Subscriber)new BulkheadSubscriber(downstream));
        } else {
            downstream.onSubscribe((Subscription)EmptySubscription.INSTANCE);
            downstream.onError((Throwable)new BulkheadFullException(this.bulkhead));
        }
    }

    class BulkheadSubscriber
    extends AbstractSubscriber<T> {
        BulkheadSubscriber(Subscriber<? super T> downstreamSubscriber) {
            super(downstreamSubscriber);
        }

        @Override
        public void hookOnError(Throwable t) {
            FlowableBulkhead.this.bulkhead.onComplete();
        }

        @Override
        public void hookOnComplete() {
            FlowableBulkhead.this.bulkhead.onComplete();
        }

        @Override
        public void hookOnCancel() {
            FlowableBulkhead.this.bulkhead.releasePermission();
        }
    }
}

