/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.operator;

import io.github.resilience4j.AbstractObserver;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.EmptyDisposable;
import java.time.Duration;

class ObserverRateLimiter<T>
extends Observable<T> {
    private final Observable<T> upstream;
    private final RateLimiter rateLimiter;

    ObserverRateLimiter(Observable<T> upstream, RateLimiter rateLimiter) {
        this.upstream = upstream;
        this.rateLimiter = rateLimiter;
    }

    protected void subscribeActual(Observer<? super T> downstream) {
        if (this.rateLimiter.acquirePermission(Duration.ZERO)) {
            this.upstream.subscribe((Observer)new RateLimiterObserver(downstream));
        } else {
            downstream.onSubscribe((Disposable)EmptyDisposable.INSTANCE);
            downstream.onError((Throwable)new RequestNotPermitted(this.rateLimiter));
        }
    }

    class RateLimiterObserver
    extends AbstractObserver<T> {
        RateLimiterObserver(Observer<? super T> downstreamObserver) {
            super(downstreamObserver);
        }

        @Override
        protected void hookOnError(Throwable e) {
        }

        @Override
        protected void hookOnComplete() {
        }

        @Override
        protected void hookOnCancel() {
        }
    }
}

