/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.operator;

import io.github.resilience4j.adapter.Permit;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class RateLimiterSubscriber<T>
extends AtomicReference<Subscription>
implements Subscriber<T>,
Subscription {
    private final RateLimiter rateLimiter;
    private final Subscriber<? super T> childSubscriber;
    private final AtomicReference<Permit> permitted = new AtomicReference<Permit>(Permit.PENDING);
    private final AtomicBoolean firstEvent = new AtomicBoolean(true);

    RateLimiterSubscriber(RateLimiter rateLimiter, Subscriber<? super T> childSubscriber) {
        this.rateLimiter = Objects.requireNonNull(rateLimiter);
        this.childSubscriber = Objects.requireNonNull(childSubscriber);
    }

    public void onSubscribe(Subscription subscription) {
        if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)subscription)) {
            if (this.acquireCallPermit()) {
                this.childSubscriber.onSubscribe((Subscription)this);
            } else {
                this.cancel();
                this.childSubscriber.onSubscribe((Subscription)this);
                this.childSubscriber.onError((Throwable)this.rateLimitExceededException());
            }
        }
    }

    public void onNext(T event) {
        if (this.isInvocationPermitted()) {
            if (this.firstEvent.getAndSet(false) || this.rateLimiter.getPermission(this.rateLimiter.getRateLimiterConfig().getTimeoutDuration())) {
                this.childSubscriber.onNext(event);
            } else {
                this.cancel();
                this.childSubscriber.onError((Throwable)this.rateLimitExceededException());
            }
        }
    }

    public void onError(Throwable e) {
        if (this.isInvocationPermitted()) {
            this.childSubscriber.onError(e);
        }
    }

    public void onComplete() {
        if (this.isInvocationPermitted()) {
            this.childSubscriber.onComplete();
        }
    }

    public void request(long n) {
        ((Subscription)this.get()).request(n);
    }

    public void cancel() {
        SubscriptionHelper.cancel((AtomicReference)this);
    }

    private boolean acquireCallPermit() {
        boolean callPermitted = false;
        if (this.permitted.compareAndSet(Permit.PENDING, Permit.ACQUIRED) && !(callPermitted = this.rateLimiter.getPermission(this.rateLimiter.getRateLimiterConfig().getTimeoutDuration()))) {
            this.permitted.set(Permit.REJECTED);
        }
        return callPermitted;
    }

    private boolean isInvocationPermitted() {
        return this.notCancelled() && this.wasCallPermitted();
    }

    private boolean notCancelled() {
        return !SubscriptionHelper.isCancelled((Subscription)((Subscription)this.get()));
    }

    private boolean wasCallPermitted() {
        return this.permitted.get() == Permit.ACQUIRED;
    }

    private Exception rateLimitExceededException() {
        return new RequestNotPermitted("Request not permitted for limiter: " + this.rateLimiter.getName());
    }
}

