/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.operator;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.operator.DisposableBulkhead;
import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import java.util.Objects;

final class BulkheadMaybeObserver<T>
extends DisposableBulkhead
implements MaybeObserver<T> {
    private final MaybeObserver<? super T> childObserver;

    BulkheadMaybeObserver(Bulkhead bulkhead, MaybeObserver<? super T> childObserver) {
        super(bulkhead);
        this.childObserver = Objects.requireNonNull(childObserver);
    }

    public void onSubscribe(Disposable disposable) {
        this.setDisposable(disposable);
        if (this.acquireCallPermit()) {
            this.childObserver.onSubscribe((Disposable)this);
        } else {
            this.dispose();
            this.childObserver.onSubscribe((Disposable)this);
            this.childObserver.onError((Throwable)this.bulkheadFullException());
        }
    }

    public void onError(Throwable e) {
        if (this.isInvocationPermitted()) {
            this.releaseBulkhead();
            this.childObserver.onError(e);
        }
    }

    public void onComplete() {
        if (this.isInvocationPermitted()) {
            this.releaseBulkhead();
            this.childObserver.onComplete();
        }
    }

    public void onSuccess(T value) {
        if (this.isInvocationPermitted()) {
            this.releaseBulkhead();
            this.childObserver.onSuccess(value);
        }
    }
}

