/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.operator;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.reactivex.FlowableOperator;
import io.reactivex.ObservableOperator;
import io.reactivex.Observer;
import io.reactivex.SingleObserver;
import io.reactivex.SingleOperator;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimiterOperator<T>
implements ObservableOperator<T, T>,
FlowableOperator<T, T>,
SingleOperator<T, T> {
    private static final Logger LOG = LoggerFactory.getLogger(RateLimiterOperator.class);
    private final RateLimiter rateLimiter;

    private RateLimiterOperator(RateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    public static <T> RateLimiterOperator<T> of(RateLimiter rateLimiter) {
        return new RateLimiterOperator<T>(rateLimiter);
    }

    public Subscriber<? super T> apply(Subscriber<? super T> childSubscriber) throws Exception {
        return new RateLimiterSubscriber(childSubscriber);
    }

    public Observer<? super T> apply(Observer<? super T> childObserver) throws Exception {
        return new RateLimiterObserver(childObserver);
    }

    public SingleObserver<? super T> apply(SingleObserver<? super T> childObserver) throws Exception {
        return new RateLimiterSingleObserver(childObserver);
    }

    private class RateLimiterSingleObserver
    implements SingleObserver<T>,
    Disposable {
        private final SingleObserver<? super T> childObserver;
        private Disposable disposable;
        private AtomicBoolean cancelled = new AtomicBoolean(false);

        RateLimiterSingleObserver(SingleObserver<? super T> childObserver) {
            this.childObserver = childObserver;
        }

        public void onSubscribe(Disposable disposable) {
            this.disposable = disposable;
            LOG.debug("onSubscribe");
            if (RateLimiterOperator.this.rateLimiter.getPermission(RateLimiterOperator.this.rateLimiter.getRateLimiterConfig().getTimeoutDuration())) {
                this.childObserver.onSubscribe((Disposable)this);
            } else {
                disposable.dispose();
                this.childObserver.onSubscribe((Disposable)this);
                this.childObserver.onError((Throwable)new RequestNotPermitted("Request not permitted for limiter: " + RateLimiterOperator.this.rateLimiter.getName()));
            }
        }

        public void onError(Throwable e) {
            LOG.debug("onError", e);
            if (!this.isDisposed()) {
                this.childObserver.onError(e);
            }
        }

        public void onSuccess(T value) {
            LOG.debug("onComplete");
            if (!this.isDisposed()) {
                this.childObserver.onSuccess(value);
            }
        }

        public void dispose() {
            if (!this.cancelled.get()) {
                this.cancelled.set(true);
                this.disposable.dispose();
            }
        }

        public boolean isDisposed() {
            return this.cancelled.get();
        }
    }

    private final class RateLimiterObserver
    implements Observer<T>,
    Disposable {
        private final Observer<? super T> childObserver;
        private Disposable disposable;
        private AtomicBoolean cancelled = new AtomicBoolean(false);

        RateLimiterObserver(Observer<? super T> childObserver) {
            this.childObserver = childObserver;
        }

        public void onSubscribe(Disposable disposable) {
            this.disposable = disposable;
            LOG.debug("onSubscribe");
            if (RateLimiterOperator.this.rateLimiter.getPermission(RateLimiterOperator.this.rateLimiter.getRateLimiterConfig().getTimeoutDuration())) {
                this.childObserver.onSubscribe((Disposable)this);
            } else {
                disposable.dispose();
                this.childObserver.onSubscribe((Disposable)this);
                this.childObserver.onError((Throwable)new RequestNotPermitted("Request not permitted for limiter: " + RateLimiterOperator.this.rateLimiter.getName()));
            }
        }

        public void onNext(T event) {
            LOG.debug("onNext: {}", event);
            if (!this.isDisposed()) {
                if (RateLimiterOperator.this.rateLimiter.getPermission(RateLimiterOperator.this.rateLimiter.getRateLimiterConfig().getTimeoutDuration())) {
                    this.childObserver.onNext(event);
                } else {
                    this.disposable.dispose();
                    this.childObserver.onError((Throwable)new RequestNotPermitted("Request not permitted for limiter: " + RateLimiterOperator.this.rateLimiter.getName()));
                }
            }
        }

        public void onError(Throwable e) {
            LOG.debug("onError", e);
            if (!this.isDisposed()) {
                this.childObserver.onError(e);
            }
        }

        public void onComplete() {
            LOG.debug("onComplete");
            if (!this.isDisposed()) {
                this.childObserver.onComplete();
            }
        }

        public void dispose() {
            if (!this.cancelled.get()) {
                this.cancelled.set(true);
                this.disposable.dispose();
            }
        }

        public boolean isDisposed() {
            return this.cancelled.get();
        }
    }

    private final class RateLimiterSubscriber
    implements Subscriber<T>,
    Subscription {
        private final Subscriber<? super T> childSubscriber;
        private Subscription subscription;
        private AtomicBoolean cancelled = new AtomicBoolean(false);

        RateLimiterSubscriber(Subscriber<? super T> childSubscriber) {
            this.childSubscriber = childSubscriber;
        }

        public void onSubscribe(Subscription subscription) {
            this.subscription = subscription;
            LOG.debug("onSubscribe");
            if (RateLimiterOperator.this.rateLimiter.getPermission(RateLimiterOperator.this.rateLimiter.getRateLimiterConfig().getTimeoutDuration())) {
                this.childSubscriber.onSubscribe((Subscription)this);
            } else {
                subscription.cancel();
                this.childSubscriber.onSubscribe((Subscription)this);
                this.childSubscriber.onError((Throwable)new RequestNotPermitted("Request not permitted for limiter: " + RateLimiterOperator.this.rateLimiter.getName()));
            }
        }

        public void onNext(T event) {
            LOG.debug("onNext: {}", event);
            if (!this.isCancelled()) {
                if (RateLimiterOperator.this.rateLimiter.getPermission(RateLimiterOperator.this.rateLimiter.getRateLimiterConfig().getTimeoutDuration())) {
                    this.childSubscriber.onNext(event);
                } else {
                    this.subscription.cancel();
                    this.childSubscriber.onError((Throwable)new RequestNotPermitted("Request not permitted for limiter: " + RateLimiterOperator.this.rateLimiter.getName()));
                }
            }
        }

        public void onError(Throwable e) {
            LOG.debug("onError", e);
            if (!this.isCancelled()) {
                this.childSubscriber.onError(e);
            }
        }

        public void onComplete() {
            LOG.debug("onComplete");
            if (!this.isCancelled()) {
                this.childSubscriber.onComplete();
            }
        }

        public void request(long n) {
            this.subscription.request(n);
        }

        public void cancel() {
            if (!this.cancelled.get()) {
                this.cancelled.set(true);
                this.subscription.cancel();
            }
        }

        public boolean isCancelled() {
            return this.cancelled.get();
        }
    }
}

