/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.bulkhead.operator;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.reactor.AbstractSubscriber;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import reactor.core.CoreSubscriber;

class BulkheadSubscriber<T>
extends AbstractSubscriber<T> {
    private final Bulkhead bulkhead;
    private final boolean singleProducer;
    private final AtomicBoolean eventWasEmitted = new AtomicBoolean(false);
    private final AtomicBoolean completedSignaled = new AtomicBoolean(false);

    BulkheadSubscriber(Bulkhead bulkhead, CoreSubscriber<? super T> downstreamSubscriber, boolean singleProducer) {
        super(downstreamSubscriber);
        this.bulkhead = Objects.requireNonNull(bulkhead);
        this.singleProducer = singleProducer;
    }

    public void hookOnNext(T t) {
        if (!this.isDisposed()) {
            if (this.singleProducer && this.completedSignaled.compareAndSet(false, true)) {
                this.bulkhead.onComplete();
            }
            this.eventWasEmitted.set(true);
            this.downstreamSubscriber.onNext(t);
        }
    }

    public void hookOnCancel() {
        if (this.completedSignaled.compareAndSet(false, true)) {
            if (this.eventWasEmitted.get()) {
                this.bulkhead.onComplete();
            } else {
                this.bulkhead.releasePermission();
            }
        }
    }

    public void hookOnError(Throwable t) {
        if (!this.completedSignaled.get()) {
            this.bulkhead.onComplete();
        }
        this.downstreamSubscriber.onError(t);
    }

    public void hookOnComplete() {
        if (this.completedSignaled.compareAndSet(false, true)) {
            this.bulkhead.onComplete();
        }
        this.downstreamSubscriber.onComplete();
    }
}

