/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.ratelimiter.operator;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.github.resilience4j.reactor.ratelimiter.operator.RateLimiterSubscriber;
import java.time.Duration;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxOperator;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

class FluxRateLimiter<T>
extends FluxOperator<T, T> {
    private final RateLimiter rateLimiter;

    FluxRateLimiter(Flux<? extends T> source, RateLimiter rateLimiter) {
        super(source);
        this.rateLimiter = rateLimiter;
    }

    public void subscribe(CoreSubscriber<? super T> actual) {
        long waitDuration = this.rateLimiter.reservePermission();
        if (waitDuration >= 0L) {
            if (waitDuration > 0L) {
                Mono.delay((Duration)Duration.ofNanos(waitDuration)).subscribe(delay -> this.source.subscribe(new RateLimiterSubscriber(actual)));
            } else {
                this.source.subscribe(new RateLimiterSubscriber<T>(actual));
            }
        } else {
            Operators.error(actual, (Throwable)RequestNotPermitted.createRequestNotPermitted((RateLimiter)this.rateLimiter));
        }
    }
}

