/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratpack.timelimiter;

import io.github.resilience4j.ratpack.internal.AbstractTransformer;
import io.github.resilience4j.timelimiter.TimeLimiter;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import ratpack.exec.Downstream;
import ratpack.exec.ExecResult;
import ratpack.exec.Execution;
import ratpack.exec.Promise;
import ratpack.exec.Upstream;
import ratpack.func.Function;

public class TimeLimiterTransformer<T>
extends AbstractTransformer<T> {
    private final TimeLimiter timeLimiter;

    private TimeLimiterTransformer(TimeLimiter timeLimiter) {
        this.timeLimiter = timeLimiter;
    }

    public static <T> TimeLimiterTransformer<T> of(TimeLimiter timeLimiter) {
        return new TimeLimiterTransformer<T>(timeLimiter);
    }

    public TimeLimiterTransformer<T> recover(Function<Throwable, ? extends T> recoverer) {
        this.recoverer = recoverer;
        return this;
    }

    public Upstream<T> apply(Upstream<? extends T> upstream) throws Exception {
        return down -> {
            Promise promise = Promise.async((Upstream)upstream);
            ScheduledExecutorService scheduler = Execution.current().getController().getExecutor();
            AtomicBoolean done = new AtomicBoolean(false);
            Promise timedPromise = Promise.async(innerDown -> {
                ScheduledFuture<?> timeoutFuture = scheduler.schedule(() -> this.scheduleTimeout(done, innerDown), this.timeLimiter.getTimeLimiterConfig().getTimeoutDuration().toMillis(), TimeUnit.MILLISECONDS);
                Execution.fork().start(execution -> promise.result(execResult -> this.onPromiseResult(done, (Downstream<? super T>)innerDown, timeoutFuture, (ExecResult<? extends T>)execResult)));
            });
            timedPromise.result(execResult -> this.onTimedPromiseResult((Downstream<? super T>)down, (ExecResult<? extends T>)execResult));
        };
    }

    public void scheduleTimeout(AtomicBoolean done, Downstream<? super T> innerDownstream) {
        if (!done.getAndSet(true)) {
            TimeoutException t = new TimeoutException();
            if (this.recoverer != null) {
                try {
                    innerDownstream.success(this.recoverer.apply((Object)t));
                }
                catch (Throwable t2) {
                    innerDownstream.error(t2);
                }
            } else {
                innerDownstream.error((Throwable)t);
            }
        }
    }

    public void onPromiseResult(AtomicBoolean done, Downstream<? super T> innerDownstream, ScheduledFuture<?> timeoutFuture, ExecResult<? extends T> execResult) {
        if (!done.getAndSet(true)) {
            if (!timeoutFuture.isDone()) {
                timeoutFuture.cancel(false);
            }
            if (execResult.getThrowable() != null) {
                innerDownstream.error(execResult.getThrowable());
            }
            if (execResult.getValue() != null) {
                innerDownstream.success(execResult.getValue());
            }
        }
    }

    public void onTimedPromiseResult(Downstream<? super T> downstream, ExecResult<? extends T> execResult) {
        Object result = execResult.getValue();
        Throwable throwable = execResult.getThrowable();
        if (result != null) {
            this.timeLimiter.onSuccess();
            downstream.success(result);
        }
        this.onException(downstream, throwable);
    }

    public void onException(Downstream<? super T> downstream, Throwable throwable) {
        if (throwable != null) {
            Throwable cause;
            if (throwable instanceof CompletionException) {
                cause = throwable.getCause();
            } else if (throwable instanceof ExecutionException) {
                cause = throwable.getCause();
                if (cause == null) {
                    cause = throwable;
                }
            } else {
                cause = throwable;
            }
            this.timeLimiter.onError(cause);
            downstream.error(cause);
        }
    }
}

