/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratpack.timelimiter;

import com.google.inject.Inject;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.ratpack.internal.AbstractMethodInterceptor;
import io.github.resilience4j.ratpack.recovery.DefaultRecoveryFunction;
import io.github.resilience4j.ratpack.recovery.RecoveryFunction;
import io.github.resilience4j.ratpack.timelimiter.TimeLimiterTransformer;
import io.github.resilience4j.reactor.timelimiter.TimeLimiterOperator;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.aopalliance.intercept.MethodInvocation;
import ratpack.exec.Execution;
import ratpack.exec.Promise;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TimeLimiterMethodInterceptor
extends AbstractMethodInterceptor {
    @Inject(optional=true)
    @Nullable
    private TimeLimiterRegistry registry;

    @Nullable
    public Object invoke(MethodInvocation invocation) throws Throwable {
        io.github.resilience4j.timelimiter.annotation.TimeLimiter annotation = invocation.getMethod().getAnnotation(io.github.resilience4j.timelimiter.annotation.TimeLimiter.class);
        if (annotation == null) {
            annotation = invocation.getMethod().getDeclaringClass().getAnnotation(io.github.resilience4j.timelimiter.annotation.TimeLimiter.class);
        }
        RecoveryFunction fallbackMethod = Optional.ofNullable(this.createRecoveryFunction(invocation, annotation.fallbackMethod())).orElse(new DefaultRecoveryFunction());
        if (this.registry == null) {
            this.registry = TimeLimiterRegistry.ofDefaults();
        }
        TimeLimiter timeLimiter = this.registry.timeLimiter(annotation.name());
        Class<?> returnType = invocation.getMethod().getReturnType();
        if (Promise.class.isAssignableFrom(returnType)) {
            return this.invokeForPromise(invocation, fallbackMethod, timeLimiter);
        }
        if (Flux.class.isAssignableFrom(returnType)) {
            return this.invokeForFlux(invocation, fallbackMethod, timeLimiter);
        }
        if (Mono.class.isAssignableFrom(returnType)) {
            return this.invokeForMono(invocation, fallbackMethod, timeLimiter);
        }
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            return this.invokeForCompletionStage(invocation, fallbackMethod, timeLimiter);
        }
        throw new IllegalArgumentException(String.join((CharSequence)" ", returnType.getName(), invocation.getMethod().getName(), "has unsupported by @TimeLimiter return type.", "Promise, Mono, Flux, or CompletionStage expected."));
    }

    public Object invokeForPromise(MethodInvocation invocation, RecoveryFunction<?> fallbackMethod, TimeLimiter timeLimiter) throws Throwable {
        Promise result = (Promise)this.proceed(invocation);
        if (result != null) {
            TimeLimiterTransformer transformer = TimeLimiterTransformer.of(timeLimiter).recover(fallbackMethod);
            result = result.transform(transformer);
        }
        return result;
    }

    public Object invokeForFlux(MethodInvocation invocation, RecoveryFunction<?> fallbackMethod, TimeLimiter timeLimiter) throws Throwable {
        Flux<?> result = (Flux<?>)this.proceed(invocation);
        if (result != null) {
            TimeLimiterOperator operator = TimeLimiterOperator.of((TimeLimiter)timeLimiter);
            result = fallbackMethod.onErrorResume(result.transform((Function)operator));
        }
        return result;
    }

    public Object invokeForMono(MethodInvocation invocation, RecoveryFunction<?> fallbackMethod, TimeLimiter timeLimiter) throws Throwable {
        Mono<?> result = (Mono<?>)this.proceed(invocation);
        if (result != null) {
            TimeLimiterOperator operator = TimeLimiterOperator.of((TimeLimiter)timeLimiter);
            result = fallbackMethod.onErrorResume(result.transform((Function)operator));
        }
        return result;
    }

    public Object invokeForCompletionStage(MethodInvocation invocation, RecoveryFunction<?> fallbackMethod, TimeLimiter timeLimiter) {
        ScheduledExecutorService scheduler = Execution.current().getController().getExecutor();
        CompletableFuture future = timeLimiter.executeCompletionStage(scheduler, () -> {
            try {
                return (CompletionStage)this.proceed(invocation);
            }
            catch (Throwable t) {
                CompletableFuture promise = new CompletableFuture();
                promise.completeExceptionally(t);
                return promise;
            }
        }).toCompletableFuture();
        this.completeFailedFuture(new TimeoutException(), fallbackMethod, future);
        return future;
    }
}

