/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratpack.recovery;

import java.util.Optional;
import ratpack.func.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface RecoveryFunction<O>
extends Function<Throwable, O> {
    default public Flux<? super O> onErrorResume(Flux<? super O> flux) {
        return flux.onErrorResume(t -> {
            Object fallbackValue;
            try {
                Throwable actual = Optional.ofNullable(t.getCause()).orElse((Throwable)t);
                fallbackValue = this.apply(actual);
                if (fallbackValue instanceof Flux) {
                    return (Flux)fallbackValue;
                }
            }
            catch (Exception e) {
                return Flux.error((Throwable)e);
            }
            return Flux.just((Object)fallbackValue);
        });
    }

    default public Mono<? super O> onErrorResume(Mono<? super O> mono) {
        return mono.onErrorResume(t -> {
            Object fallbackValue;
            try {
                Throwable actual = Optional.ofNullable(t.getCause()).orElse((Throwable)t);
                fallbackValue = this.apply(actual);
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
            return Mono.just((Object)fallbackValue);
        });
    }
}

