/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratpack.ratelimiter.monitoring.endpoint;

import io.github.resilience4j.common.ratelimiter.monitoring.endpoint.RateLimiterEventDTO;
import io.github.resilience4j.common.ratelimiter.monitoring.endpoint.RateLimiterEventsEndpointResponse;
import io.github.resilience4j.consumer.CircularEventConsumer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.EventPublisher;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.ratelimiter.event.RateLimiterEvent;
import io.github.resilience4j.ratpack.Resilience4jConfig;
import io.github.resilience4j.reactor.adapter.ReactorAdapter;
import io.vavr.collection.Seq;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import org.reactivestreams.Publisher;
import ratpack.exec.Promise;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.handling.Chain;
import ratpack.jackson.Jackson;
import ratpack.registry.Registry;
import ratpack.sse.ServerSentEvents;
import reactor.core.publisher.Flux;

public class RateLimiterChain
implements Action<Chain> {
    private final EventConsumerRegistry<RateLimiterEvent> eventConsumerRegistry;
    private final RateLimiterRegistry rateLimiterRegistry;

    @Inject
    public RateLimiterChain(EventConsumerRegistry<RateLimiterEvent> eventConsumerRegistry, RateLimiterRegistry rateLimiterRegistry) {
        this.eventConsumerRegistry = eventConsumerRegistry;
        this.rateLimiterRegistry = rateLimiterRegistry;
    }

    public void execute(Chain chain) throws Exception {
        String prefix = ((Resilience4jConfig)chain.getRegistry().get(Resilience4jConfig.class)).getEndpoints().getRatelimiter().getPath();
        chain.prefix(prefix, chain1 -> {
            chain1.get("events", ctx -> Promise.async(d -> {
                List eventsList = this.eventConsumerRegistry.getAllEventConsumer().flatMap(CircularEventConsumer::getBufferedEvents).sorted(Comparator.comparing(RateLimiterEvent::getCreationTime)).map(RateLimiterEventDTO::createRateLimiterEventDTO).toJavaList();
                d.success((Object)new RateLimiterEventsEndpointResponse(eventsList));
            }).then(r -> ctx.render((Object)Jackson.json((Object)r))));
            chain1.get("stream/events", ctx -> {
                Seq eventStreams = this.rateLimiterRegistry.getAllRateLimiters().map(rateLimiter -> ReactorAdapter.toFlux((EventPublisher)rateLimiter.getEventPublisher()));
                Function data = r -> Jackson.getObjectWriter((Registry)chain1.getRegistry()).writeValueAsString((Object)RateLimiterEventDTO.createRateLimiterEventDTO((RateLimiterEvent)r));
                ServerSentEvents events = ServerSentEvents.serverSentEvents((Publisher)Flux.merge((Iterable)eventStreams), e -> e.id(RateLimiterEvent::getRateLimiterName).event(c -> c.getEventType().name()).data(data));
                ctx.render((Object)events);
            });
            chain1.get("events/:name", ctx -> {
                String rateLimiterName = (String)ctx.getPathTokens().get((Object)"name");
                Promise.async(d -> {
                    List eventsList = this.eventConsumerRegistry.getEventConsumer(rateLimiterName).getBufferedEvents().sorted(Comparator.comparing(RateLimiterEvent::getCreationTime)).map(RateLimiterEventDTO::createRateLimiterEventDTO).toJavaList();
                    d.success((Object)new RateLimiterEventsEndpointResponse(eventsList));
                }).then(r -> ctx.render((Object)Jackson.json((Object)r)));
            });
            chain1.get("stream/events/:name", ctx -> {
                String rateLimiterName = (String)ctx.getPathTokens().get((Object)"name");
                RateLimiter rateLimiter = (RateLimiter)this.rateLimiterRegistry.getAllRateLimiters().find(rL -> rL.getName().equals(rateLimiterName)).getOrElseThrow(() -> new IllegalArgumentException(String.format("rate limiter with name %s not found", rateLimiterName)));
                Function data = r -> Jackson.getObjectWriter((Registry)chain1.getRegistry()).writeValueAsString((Object)RateLimiterEventDTO.createRateLimiterEventDTO((RateLimiterEvent)r));
                ServerSentEvents events = ServerSentEvents.serverSentEvents((Publisher)ReactorAdapter.toFlux((EventPublisher)rateLimiter.getEventPublisher()), e -> e.id(RateLimiterEvent::getRateLimiterName).event(c -> c.getEventType().name()).data(data));
                ctx.render((Object)events);
            });
            chain1.get("events/:name/:type", ctx -> {
                String rateLimiterName = (String)ctx.getPathTokens().get((Object)"name");
                String eventType = (String)ctx.getPathTokens().get((Object)"type");
                Promise.async(d -> {
                    List eventsList = this.eventConsumerRegistry.getEventConsumer(rateLimiterName).getBufferedEvents().sorted(Comparator.comparing(RateLimiterEvent::getCreationTime)).filter(event -> event.getEventType() == RateLimiterEvent.Type.valueOf((String)eventType.toUpperCase())).map(RateLimiterEventDTO::createRateLimiterEventDTO).toJavaList();
                    d.success((Object)new RateLimiterEventsEndpointResponse(eventsList));
                }).then(r -> ctx.render((Object)Jackson.json((Object)r)));
            });
            chain1.get("stream/events/:name/:type", ctx -> {
                String rateLimiterName = (String)ctx.getPathTokens().get((Object)"name");
                String eventType = (String)ctx.getPathTokens().get((Object)"type");
                RateLimiter rateLimiter = (RateLimiter)this.rateLimiterRegistry.getAllRateLimiters().find(rL -> rL.getName().equals(rateLimiterName)).getOrElseThrow(() -> new IllegalArgumentException(String.format("rate limiter with name %s not found", rateLimiterName)));
                Flux eventStream = ReactorAdapter.toFlux((EventPublisher)rateLimiter.getEventPublisher()).filter(event -> event.getEventType() == RateLimiterEvent.Type.valueOf((String)eventType.toUpperCase()));
                Function data = r -> Jackson.getObjectWriter((Registry)chain1.getRegistry()).writeValueAsString((Object)RateLimiterEventDTO.createRateLimiterEventDTO((RateLimiterEvent)r));
                ServerSentEvents events = ServerSentEvents.serverSentEvents((Publisher)eventStream, e -> e.id(RateLimiterEvent::getRateLimiterName).event(c -> c.getEventType().name()).data(data));
                ctx.render((Object)events);
            });
        });
    }
}

