/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratpack.ratelimiter;

import com.google.inject.Inject;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.ratelimiter.RequestNotPermitted;
import io.github.resilience4j.ratelimiter.annotation.RateLimiter;
import io.github.resilience4j.ratpack.internal.AbstractMethodInterceptor;
import io.github.resilience4j.ratpack.ratelimiter.RateLimiterTransformer;
import io.github.resilience4j.ratpack.recovery.DefaultRecoveryFunction;
import io.github.resilience4j.ratpack.recovery.RecoveryFunction;
import io.github.resilience4j.reactor.ratelimiter.operator.RateLimiterOperator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.aopalliance.intercept.MethodInvocation;
import ratpack.exec.Promise;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RateLimiterMethodInterceptor
extends AbstractMethodInterceptor {
    @Inject(optional=true)
    @Nullable
    private RateLimiterRegistry registry;

    @Nullable
    public Object invoke(MethodInvocation invocation) throws Throwable {
        RateLimiter annotation = invocation.getMethod().getAnnotation(RateLimiter.class);
        if (annotation == null) {
            annotation = invocation.getMethod().getDeclaringClass().getAnnotation(RateLimiter.class);
        }
        RecoveryFunction fallbackMethod = Optional.ofNullable(this.createRecoveryFunction(invocation, annotation.fallbackMethod())).orElse(new DefaultRecoveryFunction());
        if (this.registry == null) {
            this.registry = RateLimiterRegistry.ofDefaults();
        }
        io.github.resilience4j.ratelimiter.RateLimiter rateLimiter = this.registry.rateLimiter(annotation.name());
        Class<?> returnType = invocation.getMethod().getReturnType();
        if (Promise.class.isAssignableFrom(returnType)) {
            Promise result = (Promise)this.proceed(invocation);
            if (result != null) {
                RateLimiterTransformer transformer = RateLimiterTransformer.of(rateLimiter).recover(fallbackMethod);
                result = result.transform(transformer);
            }
            return result;
        }
        if (Flux.class.isAssignableFrom(returnType)) {
            Flux result = (Flux)this.proceed(invocation);
            if (result != null) {
                RateLimiterOperator operator = RateLimiterOperator.of((io.github.resilience4j.ratelimiter.RateLimiter)rateLimiter);
                result = fallbackMethod.onErrorResume(result.transform((Function)operator));
            }
            return result;
        }
        if (Mono.class.isAssignableFrom(returnType)) {
            Mono result = (Mono)this.proceed(invocation);
            if (result != null) {
                RateLimiterOperator operator = RateLimiterOperator.of((io.github.resilience4j.ratelimiter.RateLimiter)rateLimiter);
                result = fallbackMethod.onErrorResume(result.transform((Function)operator));
            }
            return result;
        }
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            if (rateLimiter.acquirePermission()) {
                return this.proceed(invocation);
            }
            CompletableFuture promise = new CompletableFuture();
            RequestNotPermitted t = RequestNotPermitted.createRequestNotPermitted((io.github.resilience4j.ratelimiter.RateLimiter)rateLimiter);
            this.completeFailedFuture((Throwable)t, fallbackMethod, promise);
            return promise;
        }
        return this.handleProceedWithException(invocation, rateLimiter, fallbackMethod);
    }

    @Nullable
    private Object handleProceedWithException(MethodInvocation invocation, io.github.resilience4j.ratelimiter.RateLimiter rateLimiter, RecoveryFunction<?> recoveryFunction) throws Throwable {
        try {
            return io.github.resilience4j.ratelimiter.RateLimiter.decorateCheckedSupplier((io.github.resilience4j.ratelimiter.RateLimiter)rateLimiter, () -> ((MethodInvocation)invocation).proceed()).apply();
        }
        catch (Throwable t) {
            return recoveryFunction.apply(t);
        }
    }
}

