/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratpack.bulkhead.monitoring.endpoint;

import io.github.resilience4j.bulkhead.event.BulkheadEvent;
import io.github.resilience4j.common.bulkhead.monitoring.endpoint.BulkheadEventDTOFactory;
import io.github.resilience4j.common.bulkhead.monitoring.endpoint.BulkheadEventsEndpointResponse;
import io.github.resilience4j.consumer.CircularEventConsumer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.ratpack.Resilience4jConfig;
import io.vavr.collection.Seq;
import java.util.Comparator;
import javax.inject.Inject;
import org.reactivestreams.Publisher;
import ratpack.exec.Promise;
import ratpack.func.Action;
import ratpack.func.Function;
import ratpack.handling.Chain;
import ratpack.jackson.Jackson;
import ratpack.registry.Registry;
import ratpack.sse.ServerSentEvents;
import reactor.core.publisher.Flux;

public class BulkheadChain
implements Action<Chain> {
    private final EventConsumerRegistry<BulkheadEvent> eventConsumerRegistry;

    @Inject
    public BulkheadChain(EventConsumerRegistry<BulkheadEvent> eventConsumerRegistry) {
        this.eventConsumerRegistry = eventConsumerRegistry;
    }

    public void execute(Chain chain) throws Exception {
        String prefix = ((Resilience4jConfig)chain.getRegistry().get(Resilience4jConfig.class)).getEndpoints().getBulkhead().getPath();
        chain.prefix(prefix, chain1 -> {
            chain1.get("events", ctx -> Promise.async(d -> {
                BulkheadEventsEndpointResponse response = new BulkheadEventsEndpointResponse(this.eventConsumerRegistry.getAllEventConsumer().flatMap(CircularEventConsumer::getBufferedEvents).sorted(Comparator.comparing(BulkheadEvent::getCreationTime)).map(BulkheadEventDTOFactory::createBulkheadEventDTO).toJavaList());
                d.success((Object)response);
            }).then(r -> ctx.render((Object)Jackson.json((Object)r))));
            chain1.get("stream/events", ctx -> {
                Seq eventStreams = this.eventConsumerRegistry.getAllEventConsumer().flatMap(CircularEventConsumer::getBufferedEvents).map(Flux::just);
                ctx.render((Object)this.serverSentEvents((Chain)chain1, (Seq<Flux<BulkheadEvent>>)eventStreams));
            });
            chain1.get("events/:name", ctx -> {
                String bulkheadName = (String)ctx.getPathTokens().get((Object)"name");
                Promise.async(d -> {
                    BulkheadEventsEndpointResponse response = new BulkheadEventsEndpointResponse(this.eventConsumerRegistry.getEventConsumer(bulkheadName).getBufferedEvents().map(BulkheadEventDTOFactory::createBulkheadEventDTO).toJavaList());
                    d.success((Object)response);
                }).then(r -> ctx.render((Object)Jackson.json((Object)r)));
            });
            chain1.get("stream/events/:name", ctx -> {
                String bulkheadName = (String)ctx.getPathTokens().get((Object)"name");
                Seq eventStreams = this.eventConsumerRegistry.getAllEventConsumer().flatMap(CircularEventConsumer::getBufferedEvents).filter(e -> e.getBulkheadName().equals(bulkheadName)).map(Flux::just);
                ctx.render((Object)this.serverSentEvents((Chain)chain1, (Seq<Flux<BulkheadEvent>>)eventStreams));
            });
            chain1.get("events/:name/:type", ctx -> {
                String bulkheadName = (String)ctx.getPathTokens().get((Object)"name");
                String eventType = (String)ctx.getPathTokens().get((Object)"type");
                Promise.async(d -> {
                    BulkheadEventsEndpointResponse response = new BulkheadEventsEndpointResponse(this.eventConsumerRegistry.getEventConsumer(bulkheadName).getBufferedEvents().filter(event -> event.getEventType() == BulkheadEvent.Type.valueOf((String)eventType.toUpperCase())).map(BulkheadEventDTOFactory::createBulkheadEventDTO).toJavaList());
                    d.success((Object)response);
                }).then(r -> ctx.render((Object)Jackson.json((Object)r)));
            });
            chain1.get("stream/events/:name/:type", ctx -> {
                String bulkheadName = (String)ctx.getPathTokens().get((Object)"name");
                String eventType = (String)ctx.getPathTokens().get((Object)"type");
                Seq eventStreams = this.eventConsumerRegistry.getAllEventConsumer().flatMap(CircularEventConsumer::getBufferedEvents).filter(e -> e.getBulkheadName().equals(bulkheadName)).filter(e -> e.getEventType().name().equals(eventType)).map(Flux::just);
                ctx.render((Object)this.serverSentEvents((Chain)chain1, (Seq<Flux<BulkheadEvent>>)eventStreams));
            });
        });
    }

    private ServerSentEvents serverSentEvents(Chain chain, Seq<Flux<BulkheadEvent>> eventStreams) {
        Function data = b -> Jackson.getObjectWriter((Registry)chain.getRegistry()).writeValueAsString((Object)BulkheadEventDTOFactory.createBulkheadEventDTO((BulkheadEvent)b));
        return ServerSentEvents.serverSentEvents((Publisher)Flux.merge(eventStreams), e -> e.id(BulkheadEvent::getBulkheadName).event(c -> c.getEventType().name()).data(data));
    }
}

