/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.ratelimiter.internal;

import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.event.RateLimiterOnFailureEvent;
import io.github.resilience4j.ratelimiter.event.RateLimiterOnSuccessEvent;
import io.github.resilience4j.ratelimiter.internal.RateLimiterEventProcessor;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.control.Option;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class SemaphoreBasedRateLimiter
implements RateLimiter {
    private static final String NAME_MUST_NOT_BE_NULL = "Name must not be null";
    private static final String CONFIG_MUST_NOT_BE_NULL = "Config must not be null";
    private final String name;
    private final AtomicReference<RateLimiterConfig> rateLimiterConfig;
    private final ScheduledExecutorService scheduler;
    private final Semaphore semaphore;
    private final SemaphoreBasedRateLimiterMetrics metrics;
    private final Map<String, String> tags;
    private final RateLimiterEventProcessor eventProcessor;

    public SemaphoreBasedRateLimiter(String name, RateLimiterConfig rateLimiterConfig) {
        this(name, rateLimiterConfig, (Map<String, String>)HashMap.empty());
    }

    public SemaphoreBasedRateLimiter(String name, RateLimiterConfig rateLimiterConfig, Map<String, String> tags) {
        this(name, rateLimiterConfig, null, tags);
    }

    public SemaphoreBasedRateLimiter(String name, RateLimiterConfig rateLimiterConfig, @Nullable ScheduledExecutorService scheduler) {
        this(name, rateLimiterConfig, scheduler, (Map<String, String>)HashMap.empty());
    }

    public SemaphoreBasedRateLimiter(String name, RateLimiterConfig rateLimiterConfig, @Nullable ScheduledExecutorService scheduler, Map<String, String> tags) {
        this.name = Objects.requireNonNull(name, NAME_MUST_NOT_BE_NULL);
        this.rateLimiterConfig = new AtomicReference<RateLimiterConfig>(Objects.requireNonNull(rateLimiterConfig, CONFIG_MUST_NOT_BE_NULL));
        this.scheduler = (ScheduledExecutorService)Option.of((Object)scheduler).getOrElse(this::configureScheduler);
        this.tags = tags;
        this.semaphore = new Semaphore(this.rateLimiterConfig.get().getLimitForPeriod(), true);
        this.metrics = new SemaphoreBasedRateLimiterMetrics();
        this.eventProcessor = new RateLimiterEventProcessor();
        this.scheduleLimitRefresh();
    }

    private ScheduledExecutorService configureScheduler() {
        ThreadFactory threadFactory = target -> {
            Thread thread = new Thread(target, "SchedulerForSemaphoreBasedRateLimiterImpl-" + this.name);
            thread.setDaemon(true);
            return thread;
        };
        return Executors.newSingleThreadScheduledExecutor(threadFactory);
    }

    private void scheduleLimitRefresh() {
        this.scheduler.scheduleAtFixedRate(this::refreshLimit, this.rateLimiterConfig.get().getLimitRefreshPeriod().toNanos(), this.rateLimiterConfig.get().getLimitRefreshPeriod().toNanos(), TimeUnit.NANOSECONDS);
    }

    void refreshLimit() {
        int permissionsToRelease = this.rateLimiterConfig.get().getLimitForPeriod() - this.semaphore.availablePermits();
        this.semaphore.release(permissionsToRelease);
    }

    @Override
    public void changeTimeoutDuration(Duration timeoutDuration) {
        RateLimiterConfig newConfig = RateLimiterConfig.from(this.rateLimiterConfig.get()).timeoutDuration(timeoutDuration).build();
        this.rateLimiterConfig.set(newConfig);
    }

    @Override
    public void changeLimitForPeriod(int limitForPeriod) {
        RateLimiterConfig newConfig = RateLimiterConfig.from(this.rateLimiterConfig.get()).limitForPeriod(limitForPeriod).build();
        this.rateLimiterConfig.set(newConfig);
    }

    @Override
    public boolean acquirePermission(int permits) {
        try {
            boolean success = this.semaphore.tryAcquire(permits, this.rateLimiterConfig.get().getTimeoutDuration().toNanos(), TimeUnit.NANOSECONDS);
            this.publishRateLimiterEvent(success, permits);
            return success;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.publishRateLimiterEvent(false, permits);
            return false;
        }
    }

    @Override
    public long reservePermission() {
        throw new UnsupportedOperationException("Reserving permissions is not supported in the spemaphore based implementation");
    }

    @Override
    public long reservePermission(int permits) {
        throw new UnsupportedOperationException("Reserving permissions is not supported in the spemaphore based implementation");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RateLimiter.Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public RateLimiter.EventPublisher getEventPublisher() {
        return this.eventProcessor;
    }

    @Override
    public RateLimiterConfig getRateLimiterConfig() {
        return this.rateLimiterConfig.get();
    }

    public String toString() {
        return "SemaphoreBasedRateLimiter{name='" + this.name + '\'' + ", rateLimiterConfig=" + this.rateLimiterConfig + '}';
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    private void publishRateLimiterEvent(boolean permissionAcquired, int permits) {
        if (!this.eventProcessor.hasConsumers()) {
            return;
        }
        if (permissionAcquired) {
            this.eventProcessor.consumeEvent(new RateLimiterOnSuccessEvent(this.name, permits));
            return;
        }
        this.eventProcessor.consumeEvent(new RateLimiterOnFailureEvent(this.name, permits));
    }

    private final class SemaphoreBasedRateLimiterMetrics
    implements RateLimiter.Metrics {
        private SemaphoreBasedRateLimiterMetrics() {
        }

        @Override
        public int getAvailablePermissions() {
            return SemaphoreBasedRateLimiter.this.semaphore.availablePermits();
        }

        @Override
        public int getNumberOfWaitingThreads() {
            return SemaphoreBasedRateLimiter.this.semaphore.getQueueLength();
        }
    }
}

