/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.prometheus.collectors;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.prometheus.LabelNames;
import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class BulkheadMetricsCollector
extends Collector {
    private final MetricNames names;
    private final BulkheadRegistry bulkheadRegistry;

    private BulkheadMetricsCollector(MetricNames names, BulkheadRegistry bulkheadRegistry) {
        this.names = Objects.requireNonNull(names);
        this.bulkheadRegistry = Objects.requireNonNull(bulkheadRegistry);
    }

    public static BulkheadMetricsCollector ofBulkheadRegistry(MetricNames names, BulkheadRegistry bulkheadRegistry) {
        return new BulkheadMetricsCollector(names, bulkheadRegistry);
    }

    public static BulkheadMetricsCollector ofBulkheadRegistry(BulkheadRegistry bulkheadRegistry) {
        return new BulkheadMetricsCollector(MetricNames.ofDefaults(), bulkheadRegistry);
    }

    public List<Collector.MetricFamilySamples> collect() {
        GaugeMetricFamily availableCallsFamily = new GaugeMetricFamily(this.names.getAvailableConcurrentCallsMetricName(), "The number of available concurrent calls", LabelNames.NAME);
        GaugeMetricFamily maxAllowedCallsFamily = new GaugeMetricFamily(this.names.getMaxAllowedConcurrentCallsMetricName(), "The maximum number of allowed concurrent calls", LabelNames.NAME);
        for (Bulkhead bulkhead : this.bulkheadRegistry.getAllBulkheads()) {
            List<String> labelValues = Collections.singletonList(bulkhead.getName());
            availableCallsFamily.addMetric(labelValues, (double)bulkhead.getMetrics().getAvailableConcurrentCalls());
            maxAllowedCallsFamily.addMetric(labelValues, (double)bulkhead.getMetrics().getMaxAllowedConcurrentCalls());
        }
        return Arrays.asList(availableCallsFamily, maxAllowedCallsFamily);
    }

    public static class MetricNames {
        public static final String DEFAULT_BULKHEAD_AVAILABLE_CONCURRENT_CALLS_METRIC_NAME = "resilience4j_bulkhead_available_concurrent_calls";
        public static final String DEFAULT_BULKHEAD_MAX_ALLOWED_CONCURRENT_CALLS_METRIC_NAME = "resilience4j_bulkhead_max_allowed_concurrent_calls";
        private String availableConcurrentCallsMetricName = "resilience4j_bulkhead_available_concurrent_calls";
        private String maxAllowedConcurrentCallsMetricName = "resilience4j_bulkhead_max_allowed_concurrent_calls";

        private MetricNames() {
        }

        public static Builder custom() {
            return new Builder();
        }

        public static MetricNames ofDefaults() {
            return new MetricNames();
        }

        public String getAvailableConcurrentCallsMetricName() {
            return this.availableConcurrentCallsMetricName;
        }

        public String getMaxAllowedConcurrentCallsMetricName() {
            return this.maxAllowedConcurrentCallsMetricName;
        }

        public static class Builder {
            private final MetricNames metricNames = new MetricNames();

            public Builder availableConcurrentCallsMetricName(String availableConcurrentCallsMetricNames) {
                this.metricNames.availableConcurrentCallsMetricName = Objects.requireNonNull(availableConcurrentCallsMetricNames);
                return this;
            }

            public Builder maxAllowedConcurrentCallsMetricName(String maxAllowedConcurrentCallsMetricName) {
                this.metricNames.maxAllowedConcurrentCallsMetricName = Objects.requireNonNull(maxAllowedConcurrentCallsMetricName);
                return this;
            }

            public MetricNames build() {
                return this.metricNames;
            }
        }
    }
}

