/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import java.util.Objects;

public abstract class AbstractTimeLimiterMetrics
extends Collector {
    protected static final String KIND_SUCCESSFUL = "successful";
    protected static final String KIND_FAILED = "failed";
    protected static final String KIND_TIMEOUT = "timeout";
    protected final MetricNames names;
    protected final CollectorRegistry collectorRegistry = new CollectorRegistry(true);
    protected final Counter callsCounter;

    protected AbstractTimeLimiterMetrics(MetricNames names) {
        this.names = Objects.requireNonNull(names);
        this.callsCounter = (Counter)((Counter.Builder)Counter.build((String)names.getCallsMetricName(), (String)"Total number of calls by kind").labelNames(new String[]{"name", "kind"})).create().register(this.collectorRegistry);
    }

    public static class MetricNames {
        public static final String DEFAULT_CALLS_METRIC_NAME = "resilience4j_timelimiter_calls";
        private String callsMetricName = "resilience4j_timelimiter_calls";

        public static Builder custom() {
            return new Builder();
        }

        public static MetricNames ofDefaults() {
            return new MetricNames();
        }

        public String getCallsMetricName() {
            return this.callsMetricName;
        }

        public static class Builder {
            private final MetricNames metricNames = new MetricNames();

            public Builder callsMetricName(String callsMetricName) {
                this.metricNames.callsMetricName = Objects.requireNonNull(callsMetricName);
                return this;
            }

            public MetricNames build() {
                return this.metricNames;
            }
        }
    }
}

