/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.prometheus;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.prometheus.LabelNames;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.GaugeMetricFamily;
import io.prometheus.client.Histogram;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class AbstractCircuitBreakerMetrics
extends Collector {
    protected static final String KIND_FAILED = "failed";
    protected static final String KIND_SUCCESSFUL = "successful";
    protected static final String KIND_IGNORED = "ignored";
    protected static final String KIND_NOT_PERMITTED = "not_permitted";
    protected static final List<String> NAME_AND_STATE = Arrays.asList("name", "state");
    protected final MetricNames names;
    protected final CollectorRegistry collectorRegistry = new CollectorRegistry(true);
    protected final Histogram callsHistogram;

    protected AbstractCircuitBreakerMetrics(MetricNames names, MetricOptions options) {
        this.names = Objects.requireNonNull(names);
        Objects.requireNonNull(options);
        this.callsHistogram = (Histogram)((Histogram.Builder)Histogram.build((String)names.getCallsMetricName(), (String)"Total number of calls by kind").labelNames(new String[]{"name", "kind"})).buckets(options.getBuckets()).create().register(this.collectorRegistry);
    }

    protected void addMetrics(CircuitBreaker circuitBreaker) {
        circuitBreaker.getEventPublisher().onCallNotPermitted(event -> ((Histogram.Child)this.callsHistogram.labels(new String[]{circuitBreaker.getName(), KIND_NOT_PERMITTED})).observe(0.0)).onIgnoredError(event -> ((Histogram.Child)this.callsHistogram.labels(new String[]{circuitBreaker.getName(), KIND_IGNORED})).observe((double)event.getElapsedDuration().toNanos() / 1.0E9)).onSuccess(event -> ((Histogram.Child)this.callsHistogram.labels(new String[]{circuitBreaker.getName(), KIND_SUCCESSFUL})).observe((double)event.getElapsedDuration().toNanos() / 1.0E9)).onError(event -> ((Histogram.Child)this.callsHistogram.labels(new String[]{circuitBreaker.getName(), KIND_FAILED})).observe((double)event.getElapsedDuration().toNanos() / 1.0E9));
    }

    protected List<Collector.MetricFamilySamples> collectGaugeSamples(List<CircuitBreaker> circuitBreakers) {
        GaugeMetricFamily stateFamily = new GaugeMetricFamily(this.names.getStateMetricName(), "The state of the circuit breaker:", NAME_AND_STATE);
        GaugeMetricFamily bufferedCallsFamily = new GaugeMetricFamily(this.names.getBufferedCallsMetricName(), "The number of buffered calls", LabelNames.NAME_AND_KIND);
        GaugeMetricFamily slowCallsFamily = new GaugeMetricFamily(this.names.getSlowCallsMetricName(), "The number of slow calls", LabelNames.NAME_AND_KIND);
        GaugeMetricFamily failureRateFamily = new GaugeMetricFamily(this.names.getFailureRateMetricName(), "The failure rate", LabelNames.NAME);
        GaugeMetricFamily slowCallRateFamily = new GaugeMetricFamily(this.names.getSlowCallRateMetricName(), "The slow call rate", LabelNames.NAME);
        for (CircuitBreaker circuitBreaker : circuitBreakers) {
            CircuitBreaker.State[] states;
            for (CircuitBreaker.State state : states = CircuitBreaker.State.values()) {
                stateFamily.addMetric(Arrays.asList(circuitBreaker.getName(), state.name().toLowerCase()), circuitBreaker.getState() == state ? 1.0 : 0.0);
            }
            List<String> nameLabel = Collections.singletonList(circuitBreaker.getName());
            CircuitBreaker.Metrics metrics = circuitBreaker.getMetrics();
            bufferedCallsFamily.addMetric(Arrays.asList(circuitBreaker.getName(), KIND_SUCCESSFUL), (double)metrics.getNumberOfSuccessfulCalls());
            bufferedCallsFamily.addMetric(Arrays.asList(circuitBreaker.getName(), KIND_FAILED), (double)metrics.getNumberOfFailedCalls());
            slowCallsFamily.addMetric(Arrays.asList(circuitBreaker.getName(), KIND_SUCCESSFUL), (double)metrics.getNumberOfSlowSuccessfulCalls());
            slowCallsFamily.addMetric(Arrays.asList(circuitBreaker.getName(), KIND_FAILED), (double)metrics.getNumberOfSlowFailedCalls());
            failureRateFamily.addMetric(nameLabel, (double)metrics.getFailureRate());
            slowCallRateFamily.addMetric(nameLabel, (double)metrics.getSlowCallRate());
        }
        return Arrays.asList(stateFamily, bufferedCallsFamily, slowCallsFamily, failureRateFamily, slowCallRateFamily);
    }

    public static class MetricOptions {
        private static final double[] DEFAULT_BUCKETS = new double[]{0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0};
        private double[] buckets = DEFAULT_BUCKETS;

        private MetricOptions() {
        }

        public static Builder custom() {
            return new Builder();
        }

        public static MetricOptions ofDefaults() {
            return new MetricOptions();
        }

        public double[] getBuckets() {
            return this.buckets;
        }

        static /* synthetic */ double[] access$802(MetricOptions x0, double[] x1) {
            x0.buckets = x1;
            return x1;
        }

        public static class Builder {
            private final MetricOptions metricOptions = new MetricOptions();

            public Builder buckets(double[] buckets) {
                MetricOptions.access$802(this.metricOptions, Objects.requireNonNull(buckets));
                return this;
            }

            public MetricOptions build() {
                return this.metricOptions;
            }
        }
    }

    public static class MetricNames {
        public static final String DEFAULT_CIRCUIT_BREAKER_CALLS = "resilience4j_circuitbreaker_calls";
        public static final String DEFAULT_CIRCUIT_BREAKER_STATE = "resilience4j_circuitbreaker_state";
        public static final String DEFAULT_CIRCUIT_BREAKER_BUFFERED_CALLS = "resilience4j_circuitbreaker_buffered_calls";
        public static final String DEFAULT_CIRCUIT_BREAKER_SLOW_CALLS = "resilience4j_circuitbreaker_slow_calls";
        public static final String DEFAULT_CIRCUIT_BREAKER_FAILURE_RATE = "resilience4j_circuitbreaker_failure_rate";
        public static final String DEFAULT_CIRCUIT_BREAKER_SLOW_CALL_RATE = "resilience4j_circuitbreaker_slow_call_rate";
        private String callsMetricName = "resilience4j_circuitbreaker_calls";
        private String stateMetricName = "resilience4j_circuitbreaker_state";
        private String bufferedCallsMetricName = "resilience4j_circuitbreaker_buffered_calls";
        private String slowCallsMetricName = "resilience4j_circuitbreaker_slow_calls";
        private String failureRateMetricName = "resilience4j_circuitbreaker_failure_rate";
        private String slowCallRateMetricName = "resilience4j_circuitbreaker_slow_call_rate";

        private MetricNames() {
        }

        public static Builder custom() {
            return new Builder();
        }

        public static MetricNames ofDefaults() {
            return new MetricNames();
        }

        public String getCallsMetricName() {
            return this.callsMetricName;
        }

        public String getBufferedCallsMetricName() {
            return this.bufferedCallsMetricName;
        }

        public String getSlowCallsMetricName() {
            return this.slowCallsMetricName;
        }

        public String getFailureRateMetricName() {
            return this.failureRateMetricName;
        }

        public String getSlowCallRateMetricName() {
            return this.slowCallRateMetricName;
        }

        public String getStateMetricName() {
            return this.stateMetricName;
        }

        public static class Builder {
            private final MetricNames metricNames = new MetricNames();

            public Builder callsMetricName(String callsMetricName) {
                this.metricNames.callsMetricName = Objects.requireNonNull(callsMetricName);
                return this;
            }

            public Builder stateMetricName(String stateMetricName) {
                this.metricNames.stateMetricName = Objects.requireNonNull(stateMetricName);
                return this;
            }

            public Builder bufferedCallsMetricName(String bufferedCallsMetricName) {
                this.metricNames.bufferedCallsMetricName = Objects.requireNonNull(bufferedCallsMetricName);
                return this;
            }

            public Builder slowCallsMetricName(String slowCallsMetricName) {
                this.metricNames.slowCallsMetricName = Objects.requireNonNull(slowCallsMetricName);
                return this;
            }

            public Builder failureRateMetricName(String failureRateMetricName) {
                this.metricNames.failureRateMetricName = Objects.requireNonNull(failureRateMetricName);
                return this;
            }

            public Builder slowCallRateMetricName(String slowCallRateMetricName) {
                this.metricNames.slowCallRateMetricName = Objects.requireNonNull(slowCallRateMetricName);
                return this;
            }

            public MetricNames build() {
                return this.metricNames;
            }
        }
    }
}

