/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micronaut.retry;

import io.github.resilience4j.common.CompositeCustomizer;
import io.github.resilience4j.common.retry.configuration.CommonRetryConfigurationProperties;
import io.github.resilience4j.common.retry.configuration.RetryConfigCustomizer;
import io.github.resilience4j.consumer.DefaultEventConsumerRegistry;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.lang.Nullable;
import io.github.resilience4j.core.registry.CompositeRegistryEventConsumer;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.micronaut.retry.RetryQualifier;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.github.resilience4j.retry.event.RetryEvent;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@Factory
@Requires(property="resilience4j.retry.enabled", value="true", defaultValue="false")
public class RetryRegistryFactory {
    @Bean
    @RetryQualifier
    public CompositeCustomizer<RetryConfigCustomizer> compositeTimeLimiterCustomizer(@Nullable List<RetryConfigCustomizer> configCustomizers) {
        return new CompositeCustomizer(configCustomizers);
    }

    @Singleton
    @Requires(beans={CommonRetryConfigurationProperties.class})
    public RetryRegistry createRetryRegistry(CommonRetryConfigurationProperties retryConfigurationProperties, @RetryQualifier EventConsumerRegistry<RetryEvent> retryEventConsumerRegistry, @RetryQualifier RegistryEventConsumer<Retry> retryRegistryEventConsumer, @RetryQualifier CompositeCustomizer<RetryConfigCustomizer> compositeRetryCustomizer) {
        RetryRegistry retryRegistry = this.createRetryRegistry(retryConfigurationProperties, retryRegistryEventConsumer, compositeRetryCustomizer);
        this.registerEventConsumer(retryRegistry, retryEventConsumerRegistry, retryConfigurationProperties);
        retryConfigurationProperties.getInstances().forEach((name, properties) -> retryRegistry.retry(name, retryConfigurationProperties.createRetryConfig(name, compositeRetryCustomizer)));
        return retryRegistry;
    }

    @Bean
    @RetryQualifier
    public EventConsumerRegistry<RetryEvent> retryEventEventConsumerRegistry() {
        return new DefaultEventConsumerRegistry();
    }

    @Bean
    @Primary
    @RetryQualifier
    public RegistryEventConsumer<Retry> retryRegistryEventConsumer(Optional<List<RegistryEventConsumer<Retry>>> optionalRegistryEventConsumers) {
        return new CompositeRegistryEventConsumer(optionalRegistryEventConsumers.orElseGet(ArrayList::new));
    }

    private void registerEventConsumer(RetryRegistry retryRegistry, EventConsumerRegistry<RetryEvent> eventConsumerRegistry, CommonRetryConfigurationProperties rateLimiterConfigurationProperties) {
        retryRegistry.getEventPublisher().onEntryAdded(event -> this.registerEventConsumer(eventConsumerRegistry, (Retry)event.getAddedEntry(), rateLimiterConfigurationProperties)).onEntryReplaced(event -> this.registerEventConsumer(eventConsumerRegistry, (Retry)event.getNewEntry(), rateLimiterConfigurationProperties)).onEntryRemoved(event -> this.unregisterEventConsumer(eventConsumerRegistry, (Retry)event.getRemovedEntry()));
    }

    private void unregisterEventConsumer(EventConsumerRegistry<RetryEvent> eventConsumerRegistry, Retry retry) {
        eventConsumerRegistry.removeEventConsumer(retry.getName());
    }

    private void registerEventConsumer(EventConsumerRegistry<RetryEvent> eventConsumerRegistry, Retry retry, CommonRetryConfigurationProperties retryConfigurationProperties) {
        int eventConsumerBufferSize = Optional.ofNullable(retryConfigurationProperties.getBackendProperties(retry.getName())).map(CommonRetryConfigurationProperties.InstanceProperties::getEventConsumerBufferSize).orElse(100);
        retry.getEventPublisher().onEvent((EventConsumer)eventConsumerRegistry.createEventConsumer(retry.getName(), eventConsumerBufferSize));
    }

    private RetryRegistry createRetryRegistry(CommonRetryConfigurationProperties retryProperties, RegistryEventConsumer<Retry> rateLimiterRegistryEventConsumer, CompositeCustomizer<RetryConfigCustomizer> compositeRateLimiterCustomizer) {
        Map<String, RetryConfig> configs = retryProperties.getConfigs().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> retryProperties.createRetryConfig((CommonRetryConfigurationProperties.InstanceProperties)entry.getValue(), compositeRateLimiterCustomizer, (String)entry.getKey())));
        return RetryRegistry.of(configs, rateLimiterRegistryEventConsumer, (Map)retryProperties.getTags());
    }
}

