/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micronaut.ratelimiter;

import io.github.resilience4j.micronaut.BaseInterceptor;
import io.github.resilience4j.micronaut.ResilienceInterceptPhase;
import io.github.resilience4j.micronaut.util.PublisherExtension;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.InterceptorBean;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.MethodExecutionHandle;
import java.util.Optional;
import java.util.concurrent.CompletionException;

@InterceptorBean(value={io.github.resilience4j.micronaut.annotation.RateLimiter.class})
@Requires(beans={RateLimiterRegistry.class})
public class RateLimiterInterceptor
extends BaseInterceptor
implements MethodInterceptor<Object, Object> {
    private final RateLimiterRegistry rateLimiterRegistry;
    private final ExecutionHandleLocator executionHandleLocator;
    private final PublisherExtension extension;
    private final ConversionService conversionService;

    public RateLimiterInterceptor(ExecutionHandleLocator executionHandleLocator, RateLimiterRegistry rateLimiterRegistry, PublisherExtension extension, ConversionService conversionService) {
        this.rateLimiterRegistry = rateLimiterRegistry;
        this.executionHandleLocator = executionHandleLocator;
        this.extension = extension;
        this.conversionService = conversionService;
    }

    public int getOrder() {
        return ResilienceInterceptPhase.RATE_LIMITER.getPosition();
    }

    @Override
    public Optional<? extends MethodExecutionHandle<?, Object>> findFallbackMethod(MethodInvocationContext<Object, Object> context) {
        ExecutableMethod executableMethod = context.getExecutableMethod();
        String fallbackMethod = executableMethod.stringValue(io.github.resilience4j.micronaut.annotation.RateLimiter.class, "fallbackMethod").orElse("");
        Class declaringType = context.getDeclaringType();
        return this.executionHandleLocator.findExecutionHandle(declaringType, fallbackMethod, context.getArgumentTypes());
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        if (!context.hasAnnotation(io.github.resilience4j.micronaut.annotation.RateLimiter.class)) {
            return context.proceed();
        }
        ExecutableMethod executableMethod = context.getExecutableMethod();
        String name = executableMethod.stringValue(io.github.resilience4j.micronaut.annotation.RateLimiter.class, "name").orElse("default");
        RateLimiter rateLimiter = this.rateLimiterRegistry.rateLimiter(name);
        InterceptedMethod interceptedMethod = InterceptedMethod.of(context, (ConversionService)this.conversionService);
        try {
            switch (interceptedMethod.resultType()) {
                case PUBLISHER: {
                    return interceptedMethod.handleResult(this.extension.fallbackPublisher(this.extension.rateLimiter(interceptedMethod.interceptResultAsPublisher(), rateLimiter), context, this::findFallbackMethod));
                }
                case COMPLETION_STAGE: {
                    return interceptedMethod.handleResult(this.fallbackForFuture(rateLimiter.executeCompletionStage(() -> {
                        try {
                            return interceptedMethod.interceptResultAsCompletionStage();
                        }
                        catch (Exception e) {
                            throw new CompletionException(e);
                        }
                    }), context));
                }
                case SYNCHRONOUS: {
                    try {
                        return rateLimiter.executeCheckedSupplier(() -> context.proceed());
                    }
                    catch (Throwable exception) {
                        return this.fallback(context, exception);
                    }
                }
            }
            return interceptedMethod.unsupported();
        }
        catch (Exception e) {
            return interceptedMethod.handleException(e);
        }
    }
}

