/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micronaut.retry;

import io.github.resilience4j.micronaut.BaseInterceptor;
import io.github.resilience4j.micronaut.ResilienceInterceptPhase;
import io.github.resilience4j.micronaut.util.PublisherExtension;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryRegistry;
import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.annotation.Requires;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.MethodExecutionHandle;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

@Singleton
@Requires(beans={RetryRegistry.class})
public class RetryInterceptor
extends BaseInterceptor
implements MethodInterceptor<Object, Object> {
    private final RetryRegistry retryRegistry;
    private final ExecutionHandleLocator executionHandleLocator;
    private final ScheduledExecutorService executorService;
    private final PublisherExtension extension;

    public RetryInterceptor(ExecutionHandleLocator executionHandleLocator, RetryRegistry retryRegistry, @Named(value="scheduled") ExecutorService executorService, PublisherExtension extension) {
        this.retryRegistry = retryRegistry;
        this.executionHandleLocator = executionHandleLocator;
        this.executorService = (ScheduledExecutorService)executorService;
        this.extension = extension;
    }

    public int getOrder() {
        return ResilienceInterceptPhase.RETRY.getPosition();
    }

    @Override
    public Optional<? extends MethodExecutionHandle<?, Object>> findFallbackMethod(MethodInvocationContext<Object, Object> context) {
        ExecutableMethod executableMethod = context.getExecutableMethod();
        String fallbackMethod = executableMethod.stringValue(io.github.resilience4j.micronaut.annotation.Retry.class, "fallbackMethod").orElse("");
        Class declaringType = context.getDeclaringType();
        return this.executionHandleLocator.findExecutionHandle(declaringType, fallbackMethod, context.getArgumentTypes());
    }

    public Object intercept(MethodInvocationContext<Object, Object> context) {
        Optional opt = context.findAnnotation(io.github.resilience4j.micronaut.annotation.Retry.class);
        if (!opt.isPresent()) {
            return context.proceed();
        }
        ExecutableMethod executableMethod = context.getExecutableMethod();
        String name = executableMethod.stringValue(io.github.resilience4j.micronaut.annotation.Retry.class, "name").orElse("default");
        Retry retry = this.retryRegistry.retry(name);
        InterceptedMethod interceptedMethod = InterceptedMethod.of(context);
        try {
            switch (interceptedMethod.resultType()) {
                case PUBLISHER: {
                    return interceptedMethod.handleResult(this.extension.fallbackPublisher(this.extension.retry(interceptedMethod.interceptResultAsPublisher(), retry), context, this::findFallbackMethod));
                }
                case COMPLETION_STAGE: {
                    return interceptedMethod.handleResult(this.fallbackForFuture(retry.executeCompletionStage(this.executorService, () -> {
                        try {
                            return interceptedMethod.interceptResultAsCompletionStage();
                        }
                        catch (Exception e) {
                            throw new CompletionException(e);
                        }
                    }), context));
                }
                case SYNCHRONOUS: {
                    try {
                        return retry.executeCheckedSupplier(() -> context.proceed());
                    }
                    catch (Throwable exception) {
                        return this.fallback(context, exception);
                    }
                }
            }
            return interceptedMethod.unsupported();
        }
        catch (Exception e) {
            return interceptedMethod.handleException(e);
        }
    }
}

