/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.tagged;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.github.resilience4j.micrometer.tagged.AbstractMetrics;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.HashSet;
import java.util.Objects;

public class TaggedBulkheadMetrics
extends AbstractMetrics
implements MeterBinder {
    private final MetricNames names;
    private final BulkheadRegistry bulkheadRegistry;

    public static TaggedBulkheadMetrics ofBulkheadRegistry(BulkheadRegistry bulkheadRegistry) {
        return new TaggedBulkheadMetrics(MetricNames.ofDefaults(), bulkheadRegistry);
    }

    public static TaggedBulkheadMetrics ofBulkheadRegistry(MetricNames names, BulkheadRegistry bulkheadRegistry) {
        return new TaggedBulkheadMetrics(names, bulkheadRegistry);
    }

    private TaggedBulkheadMetrics(MetricNames names, BulkheadRegistry bulkheadRegistry) {
        this.names = Objects.requireNonNull(names);
        this.bulkheadRegistry = Objects.requireNonNull(bulkheadRegistry);
    }

    public void bindTo(MeterRegistry registry) {
        for (Bulkhead bulkhead : this.bulkheadRegistry.getAllBulkheads()) {
            this.addMetrics(registry, bulkhead);
        }
        this.bulkheadRegistry.getEventPublisher().onEntryAdded(event -> this.addMetrics(registry, (Bulkhead)event.getAddedEntry()));
        this.bulkheadRegistry.getEventPublisher().onEntryRemoved(event -> this.removeMetrics(registry, ((Bulkhead)event.getRemovedEntry()).getName()));
        this.bulkheadRegistry.getEventPublisher().onEntryReplaced(event -> {
            this.removeMetrics(registry, ((Bulkhead)event.getOldEntry()).getName());
            this.addMetrics(registry, (Bulkhead)event.getNewEntry());
        });
    }

    private void addMetrics(MeterRegistry registry, Bulkhead bulkhead) {
        HashSet<Meter.Id> idSet = new HashSet<Meter.Id>();
        idSet.add(Gauge.builder((String)this.names.getAvailableConcurrentCallsMetricName(), (Object)bulkhead, bh -> bh.getMetrics().getAvailableConcurrentCalls()).description("The number of available permissions").tag("name", bulkhead.getName()).register(registry).getId());
        idSet.add(Gauge.builder((String)this.names.getMaxAllowedConcurrentCallsMetricName(), (Object)bulkhead, bh -> bh.getMetrics().getMaxAllowedConcurrentCalls()).description("The maximum number of available permissions").tag("name", bulkhead.getName()).register(registry).getId());
        this.meterIdMap.put(bulkhead.getName(), idSet);
    }

    public static class MetricNames {
        private static final String DEFAULT_PREFIX = "resilience4j.bulkhead";
        public static final String DEFAULT_BULKHEAD_AVAILABLE_CONCURRENT_CALLS_METRIC_NAME = "resilience4j.bulkhead.available.concurrent_calls";
        public static final String DEFAULT_BULKHEAD_MAX_ALLOWED_CONCURRENT_CALLS_METRIC_NAME = "resilience4j.bulkhead.max_allowed.concurrent.calls";
        private String availableConcurrentCallsMetricName = "resilience4j.bulkhead.available.concurrent_calls";
        private String maxAllowedConcurrentCallsMetricName = "resilience4j.bulkhead.max_allowed.concurrent.calls";

        public static Builder custom() {
            return new Builder();
        }

        public static MetricNames ofDefaults() {
            return new MetricNames();
        }

        private MetricNames() {
        }

        public String getAvailableConcurrentCallsMetricName() {
            return this.availableConcurrentCallsMetricName;
        }

        public String getMaxAllowedConcurrentCallsMetricName() {
            return this.maxAllowedConcurrentCallsMetricName;
        }

        public static class Builder {
            private final MetricNames metricNames = new MetricNames();

            public Builder availableConcurrentCallsMetricName(String availableConcurrentCallsMetricNames) {
                this.metricNames.availableConcurrentCallsMetricName = Objects.requireNonNull(availableConcurrentCallsMetricNames);
                return this;
            }

            public Builder maxAllowedConcurrentCallsMetricName(String maxAllowedConcurrentCallsMetricName) {
                this.metricNames.maxAllowedConcurrentCallsMetricName = Objects.requireNonNull(maxAllowedConcurrentCallsMetricName);
                return this;
            }

            public MetricNames build() {
                return this.metricNames;
            }
        }
    }
}

