/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.tagged;

import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Objects;

public class TaggedRateLimiterMetrics
implements MeterBinder {
    private final MetricNames names;
    private final Iterable<? extends RateLimiter> rateLimiters;

    public static TaggedRateLimiterMetrics ofRateLimiterRegistry(RateLimiterRegistry registry) {
        return new TaggedRateLimiterMetrics(MetricNames.ofDefaults(), (Iterable<? extends RateLimiter>)registry.getAllRateLimiters());
    }

    public static TaggedRateLimiterMetrics ofRateLimiterRegistry(MetricNames names, RateLimiterRegistry registry) {
        return new TaggedRateLimiterMetrics(names, (Iterable<? extends RateLimiter>)registry.getAllRateLimiters());
    }

    private TaggedRateLimiterMetrics(MetricNames names, Iterable<? extends RateLimiter> rateLimiters) {
        this.names = Objects.requireNonNull(names);
        this.rateLimiters = Objects.requireNonNull(rateLimiters);
    }

    public void bindTo(MeterRegistry registry) {
        for (RateLimiter rateLimiter : this.rateLimiters) {
            Gauge.builder((String)this.names.getAvailablePermissionsMetricName(), (Object)rateLimiter, rl -> rl.getMetrics().getAvailablePermissions()).tag("name", rateLimiter.getName()).register(registry);
            Gauge.builder((String)this.names.getWaitingThreadsMetricName(), (Object)rateLimiter, rl -> rl.getMetrics().getNumberOfWaitingThreads()).tag("name", rateLimiter.getName()).register(registry);
        }
    }

    public static class MetricNames {
        public static final String DEFAULT_AVAILABLE_PERMISSIONS_METRIC_NAME = "resilience4j_ratelimiter_available_permissions";
        public static final String DEFAULT_WAITING_THREADS_METRIC_NAME = "resilience4j_ratelimiter_waiting_threads";
        private String availablePermissionsMetricName = "resilience4j_ratelimiter_available_permissions";
        private String waitingThreadsMetricName = "resilience4j_ratelimiter_waiting_threads";

        public static Builder custom() {
            return new Builder();
        }

        public static MetricNames ofDefaults() {
            return new MetricNames();
        }

        public String getAvailablePermissionsMetricName() {
            return this.availablePermissionsMetricName;
        }

        public String getWaitingThreadsMetricName() {
            return this.waitingThreadsMetricName;
        }

        public static class Builder {
            private final MetricNames metricNames = new MetricNames();

            public Builder availablePermissionsMetricName(String availablePermissionsMetricName) {
                this.metricNames.availablePermissionsMetricName = Objects.requireNonNull(availablePermissionsMetricName);
                return this;
            }

            public Builder waitingThreadsMetricName(String waitingThreadsMetricName) {
                this.metricNames.waitingThreadsMetricName = Objects.requireNonNull(waitingThreadsMetricName);
                return this;
            }

            public MetricNames build() {
                return this.metricNames;
            }
        }
    }
}

