/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer.tagged;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadRegistry;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.Objects;

public class TaggedBulkheadMetrics
implements MeterBinder {
    private final MetricNames names;
    private final Iterable<? extends Bulkhead> bulkheads;

    public static TaggedBulkheadMetrics ofBulkheadRegistry(BulkheadRegistry registry) {
        return new TaggedBulkheadMetrics(MetricNames.ofDefaults(), (Iterable<? extends Bulkhead>)registry.getAllBulkheads());
    }

    public static TaggedBulkheadMetrics ofBulkheadRegistry(MetricNames names, BulkheadRegistry registry) {
        return new TaggedBulkheadMetrics(names, (Iterable<? extends Bulkhead>)registry.getAllBulkheads());
    }

    private TaggedBulkheadMetrics(MetricNames names, Iterable<? extends Bulkhead> bulkheads) {
        this.names = Objects.requireNonNull(names);
        this.bulkheads = Objects.requireNonNull(bulkheads);
    }

    public void bindTo(MeterRegistry registry) {
        for (Bulkhead bulkhead : this.bulkheads) {
            Gauge.builder((String)this.names.getAvailableConcurrentCallsMetricName(), (Object)bulkhead, bh -> bh.getMetrics().getAvailableConcurrentCalls()).tag("name", bulkhead.getName()).register(registry);
            Gauge.builder((String)this.names.getMaxAllowedConcurrentCallsMetricName(), (Object)bulkhead, bh -> bh.getMetrics().getMaxAllowedConcurrentCalls()).tag("name", bulkhead.getName()).register(registry);
        }
    }

    public static class MetricNames {
        public static final String DEFAULT_BULKHEAD_AVAILABLE_CONCURRENT_CALLS_METRIC_NAME = "resilience4j_bulkhead_available_concurrent_calls";
        public static final String DEFAULT_BULKHEAD_MAX_ALLOWED_CONCURRENT_CALLS_METRIC_NAME = "resilience4j_bulkhead_max_allowed_concurrent_calls";
        private String availableConcurrentCallsMetricName = "resilience4j_bulkhead_available_concurrent_calls";
        private String maxAllowedConcurrentCallsMetricName = "resilience4j_bulkhead_max_allowed_concurrent_calls";

        public static Builder custom() {
            return new Builder();
        }

        public static MetricNames ofDefaults() {
            return new MetricNames();
        }

        private MetricNames() {
        }

        public String getAvailableConcurrentCallsMetricName() {
            return this.availableConcurrentCallsMetricName;
        }

        public String getMaxAllowedConcurrentCallsMetricName() {
            return this.maxAllowedConcurrentCallsMetricName;
        }

        public static class Builder {
            private final MetricNames metricNames = new MetricNames();

            public Builder availableConcurrentCallsMetricName(String availableConcurrentCallsMetricNames) {
                this.metricNames.availableConcurrentCallsMetricName = Objects.requireNonNull(availableConcurrentCallsMetricNames);
                return this;
            }

            public Builder maxAllowedConcurrentCallsMetricName(String maxAllowedConcurrentCallsMetricName) {
                this.metricNames.maxAllowedConcurrentCallsMetricName = Objects.requireNonNull(maxAllowedConcurrentCallsMetricName);
                return this;
            }

            public MetricNames build() {
                return this.metricNames;
            }
        }
    }
}

