/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.metrics.publisher;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.metrics.publisher.AbstractMetricsPublisher;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class BulkheadMetricsPublisher
extends AbstractMetricsPublisher<Bulkhead> {
    private final String prefix;

    public BulkheadMetricsPublisher() {
        this("resilience4j.bulkhead", new MetricRegistry());
    }

    public BulkheadMetricsPublisher(MetricRegistry metricRegistry) {
        this("resilience4j.bulkhead", metricRegistry);
    }

    public BulkheadMetricsPublisher(String prefix, MetricRegistry metricRegistry) {
        super(metricRegistry);
        this.prefix = Objects.requireNonNull(prefix);
    }

    public void publishMetrics(Bulkhead bulkhead) {
        String name = bulkhead.getName();
        String availableConcurrentCalls = MetricRegistry.name((String)this.prefix, (String[])new String[]{name, "available_concurrent_calls"});
        String maxAllowedConcurrentCalls = MetricRegistry.name((String)this.prefix, (String[])new String[]{name, "max_allowed_concurrent_calls"});
        this.metricRegistry.register(availableConcurrentCalls, (Metric)((Gauge)() -> bulkhead.getMetrics().getAvailableConcurrentCalls()));
        this.metricRegistry.register(maxAllowedConcurrentCalls, (Metric)((Gauge)() -> bulkhead.getMetrics().getMaxAllowedConcurrentCalls()));
        List<String> metricNames = Arrays.asList(availableConcurrentCalls, maxAllowedConcurrentCalls);
        this.metricsNameMap.put(name, new HashSet<String>(metricNames));
    }

    public void removeMetrics(Bulkhead bulkhead) {
        this.removeMetrics(bulkhead.getName());
    }
}

