/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.metrics.publisher;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import io.github.resilience4j.metrics.publisher.AbstractMetricsPublisher;
import io.github.resilience4j.retry.Retry;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class RetryMetricsPublisher
extends AbstractMetricsPublisher<Retry> {
    private final String prefix;

    public RetryMetricsPublisher() {
        this("resilience4j.retry", new MetricRegistry());
    }

    public RetryMetricsPublisher(MetricRegistry metricRegistry) {
        this("resilience4j.retry", metricRegistry);
    }

    public RetryMetricsPublisher(String prefix, MetricRegistry metricRegistry) {
        super(metricRegistry);
        this.prefix = Objects.requireNonNull(prefix);
    }

    public void publishMetrics(Retry retry) {
        String name = retry.getName();
        String successfulWithoutRetry = MetricRegistry.name((String)this.prefix, (String[])new String[]{name, "successful_calls_without_retry"});
        String successfulWithRetry = MetricRegistry.name((String)this.prefix, (String[])new String[]{name, "successful_calls_with_retry"});
        String failedWithoutRetry = MetricRegistry.name((String)this.prefix, (String[])new String[]{name, "failed_calls_without_retry"});
        String failedWithRetry = MetricRegistry.name((String)this.prefix, (String[])new String[]{name, "failed_calls_with_retry"});
        this.metricRegistry.register(successfulWithoutRetry, (Metric)((Gauge)() -> retry.getMetrics().getNumberOfSuccessfulCallsWithoutRetryAttempt()));
        this.metricRegistry.register(successfulWithRetry, (Metric)((Gauge)() -> retry.getMetrics().getNumberOfSuccessfulCallsWithRetryAttempt()));
        this.metricRegistry.register(failedWithoutRetry, (Metric)((Gauge)() -> retry.getMetrics().getNumberOfFailedCallsWithoutRetryAttempt()));
        this.metricRegistry.register(failedWithRetry, (Metric)((Gauge)() -> retry.getMetrics().getNumberOfFailedCallsWithRetryAttempt()));
        List<String> metricNames = Arrays.asList(successfulWithoutRetry, successfulWithRetry, failedWithoutRetry, failedWithRetry);
        this.metricsNameMap.put(name, new HashSet<String>(metricNames));
    }

    public void removeMetrics(Retry retry) {
        this.removeMetrics(retry.getName());
    }
}

