/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import io.github.resilience4j.timelimiter.TimeLimiter;
import io.github.resilience4j.timelimiter.TimeLimiterRegistry;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TimeLimiterMetrics
implements MetricSet {
    private final MetricRegistry metricRegistry;

    private TimeLimiterMetrics(Iterable<TimeLimiter> timeLimiters) {
        this("resilience4j.timelimiter", timeLimiters, new MetricRegistry());
    }

    private TimeLimiterMetrics(String prefix, Iterable<TimeLimiter> timeLimiters, MetricRegistry metricRegistry) {
        Objects.requireNonNull(prefix, "Prefix must not be null");
        Objects.requireNonNull(timeLimiters, "TimeLimiters iterable must not be null");
        Objects.requireNonNull(metricRegistry);
        this.metricRegistry = metricRegistry;
        timeLimiters.forEach(timeLimiter -> {
            String name = timeLimiter.getName();
            Counter successes = metricRegistry.counter(MetricRegistry.name((String)prefix, (String[])new String[]{name, "successful"}));
            Counter failures = metricRegistry.counter(MetricRegistry.name((String)prefix, (String[])new String[]{name, "failed"}));
            Counter timeouts = metricRegistry.counter(MetricRegistry.name((String)prefix, (String[])new String[]{name, "timeout"}));
            timeLimiter.getEventPublisher().onSuccess(event -> successes.inc());
            timeLimiter.getEventPublisher().onError(event -> failures.inc());
            timeLimiter.getEventPublisher().onTimeout(event -> timeouts.inc());
        });
    }

    public static TimeLimiterMetrics ofTimeLimiterRegistry(String prefix, TimeLimiterRegistry timeLimiterRegistry, MetricRegistry metricRegistry) {
        return new TimeLimiterMetrics(prefix, timeLimiterRegistry.getAllTimeLimiters(), metricRegistry);
    }

    public static TimeLimiterMetrics ofTimeLimiterRegistry(String prefix, TimeLimiterRegistry timeLimiterRegistry) {
        return new TimeLimiterMetrics(prefix, timeLimiterRegistry.getAllTimeLimiters(), new MetricRegistry());
    }

    public static TimeLimiterMetrics ofTimeLimiterRegistry(TimeLimiterRegistry timeLimiterRegistry, MetricRegistry metricRegistry) {
        return new TimeLimiterMetrics("resilience4j.timelimiter", timeLimiterRegistry.getAllTimeLimiters(), metricRegistry);
    }

    public static TimeLimiterMetrics ofTimeLimiterRegistry(TimeLimiterRegistry timeLimiterRegistry) {
        return new TimeLimiterMetrics(timeLimiterRegistry.getAllTimeLimiters());
    }

    public static TimeLimiterMetrics ofIterable(Iterable<TimeLimiter> timeLimiters) {
        return new TimeLimiterMetrics(timeLimiters);
    }

    public static TimeLimiterMetrics ofIterable(String prefix, Iterable<TimeLimiter> timeLimiters) {
        return new TimeLimiterMetrics(prefix, timeLimiters, new MetricRegistry());
    }

    public static TimeLimiterMetrics ofTimeLimiter(TimeLimiter timeLimiter) {
        return new TimeLimiterMetrics(List.of(timeLimiter));
    }

    public Map<String, Metric> getMetrics() {
        return this.metricRegistry.getMetrics();
    }
}

