/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.metrics.internal;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import io.github.resilience4j.metrics.Timer;

public class TimerImpl
implements Timer {
    public static final String SUCCESSFUL = "successful";
    public static final String TOTAL = "total";
    public static final String FAILED = "failed";
    private final String timerName;
    private final MetricRegistry metricRegistry;
    private final TimerMetrics metrics;
    private com.codahale.metrics.Timer successfulCallsTimer;
    private Counter totalCallsCounter;
    private Counter failedCallsCounter;

    public TimerImpl(String timerName, MetricRegistry metricRegistry) {
        this.timerName = timerName;
        this.metricRegistry = metricRegistry;
        this.successfulCallsTimer = metricRegistry.timer(MetricRegistry.name((String)timerName, (String[])new String[]{SUCCESSFUL}));
        this.totalCallsCounter = metricRegistry.counter(MetricRegistry.name((String)timerName, (String[])new String[]{TOTAL}));
        this.failedCallsCounter = metricRegistry.counter(MetricRegistry.name((String)timerName, (String[])new String[]{FAILED}));
        this.metrics = new TimerMetrics();
    }

    @Override
    public Timer.Context context() {
        this.totalCallsCounter.inc();
        return new ContextImpl();
    }

    @Override
    public String getName() {
        return this.timerName;
    }

    @Override
    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    @Override
    public Timer.Metrics getMetrics() {
        return this.metrics;
    }

    private final class TimerMetrics
    implements Timer.Metrics {
        private TimerMetrics() {
        }

        @Override
        public long getNumberOfTotalCalls() {
            return TimerImpl.this.totalCallsCounter.getCount();
        }

        @Override
        public long getNumberOfSuccessfulCalls() {
            return TimerImpl.this.successfulCallsTimer.getCount();
        }

        @Override
        public long getNumberOfFailedCalls() {
            return TimerImpl.this.failedCallsCounter.getCount();
        }

        @Override
        public double getFifteenMinuteRate() {
            return TimerImpl.this.successfulCallsTimer.getFifteenMinuteRate();
        }

        @Override
        public double getFiveMinuteRate() {
            return TimerImpl.this.successfulCallsTimer.getFiveMinuteRate();
        }

        @Override
        public double getMeanRate() {
            return TimerImpl.this.successfulCallsTimer.getMeanRate();
        }

        @Override
        public double getOneMinuteRate() {
            return TimerImpl.this.successfulCallsTimer.getOneMinuteRate();
        }

        @Override
        public Snapshot getSnapshot() {
            return TimerImpl.this.successfulCallsTimer.getSnapshot();
        }
    }

    public final class ContextImpl
    implements Timer.Context {
        Timer.Context timerContext;

        private ContextImpl() {
            this.timerContext = TimerImpl.this.successfulCallsTimer.time();
        }

        @Override
        public void onError() {
            TimerImpl.this.failedCallsCounter.inc();
        }

        @Override
        public void onSuccess() {
            this.timerContext.stop();
        }
    }
}

