/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.hedge.internal;

import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.registry.AbstractRegistry;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.hedge.Hedge;
import io.github.resilience4j.hedge.HedgeConfig;
import io.github.resilience4j.hedge.HedgeRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class InMemoryHedgeRegistry
extends AbstractRegistry<Hedge, HedgeConfig>
implements HedgeRegistry {
    public InMemoryHedgeRegistry(HedgeConfig defaultConfig, List<RegistryEventConsumer<Hedge>> registryEventConsumers, Map<String, String> tags) {
        super((Object)defaultConfig, registryEventConsumers, tags);
    }

    @Override
    public Stream<Hedge> getAllHedges() {
        return this.entryMap.values().stream();
    }

    @Override
    public Hedge hedge(String name) {
        return this.hedge(name, (HedgeConfig)this.getDefaultConfig(), Collections.emptyMap());
    }

    @Override
    public Hedge hedge(String name, Map<String, String> tags) {
        return this.hedge(name, (HedgeConfig)this.getDefaultConfig(), tags);
    }

    @Override
    public Hedge hedge(String name, HedgeConfig config) {
        return this.hedge(name, config, Collections.emptyMap());
    }

    @Override
    public Hedge hedge(String name, HedgeConfig hedgeConfig, Map<String, String> tags) {
        return (Hedge)this.computeIfAbsent(name, () -> Hedge.of(name, Objects.requireNonNull(hedgeConfig, "Config must not be null"), this.getAllTags(tags)));
    }

    @Override
    public Hedge hedge(String name, Supplier<HedgeConfig> hedgeConfigSupplier) {
        return this.hedge(name, hedgeConfigSupplier, Collections.emptyMap());
    }

    @Override
    public Hedge hedge(String name, Supplier<HedgeConfig> hedgeConfigSupplier, Map<String, String> tags) {
        return (Hedge)this.computeIfAbsent(name, () -> Hedge.of(name, Objects.requireNonNull((HedgeConfig)Objects.requireNonNull(hedgeConfigSupplier, "Supplier must not be null").get(), "Config must not be null"), this.getAllTags(tags)));
    }

    @Override
    public Hedge hedge(String name, String configName) {
        return this.hedge(name, configName, Collections.emptyMap());
    }

    @Override
    public Hedge hedge(String name, String configName, Map<String, String> tags) {
        HedgeConfig config = (HedgeConfig)this.getConfiguration(configName).orElseThrow(() -> new ConfigurationNotFoundException(configName));
        return this.hedge(name, config, tags);
    }

    public static class Builder {
        private final Map<String, String> tags = new HashMap<String, String>();
        private final Map<String, HedgeConfig> configs = new HashMap<String, HedgeConfig>();
        private HedgeConfig defaultConfig = HedgeConfig.ofDefaults();
        private final List<RegistryEventConsumer<Hedge>> consumers = new ArrayList<RegistryEventConsumer<Hedge>>();

        public Builder withTags(Map<String, String> tags) {
            this.tags.putAll(tags);
            return this;
        }

        public Builder withConfigs(Map<String, HedgeConfig> configs) {
            this.configs.putAll(configs);
            return this;
        }

        public Builder withDefaultConfig(HedgeConfig config) {
            if (config == null) {
                throw new NullPointerException("Config must not be null");
            }
            this.defaultConfig = config;
            return this;
        }

        public Builder withConsumers(List<RegistryEventConsumer<Hedge>> registryEventConsumers) {
            this.consumers.addAll(registryEventConsumers);
            return this;
        }

        public Builder withConsumer(RegistryEventConsumer<Hedge> registryEventConsumer) {
            this.consumers.add(registryEventConsumer);
            return this;
        }

        public HedgeRegistry build() {
            this.configs.remove("default");
            InMemoryHedgeRegistry registry = new InMemoryHedgeRegistry(this.defaultConfig, this.consumers, this.tags);
            this.configs.forEach((arg_0, arg_1) -> ((HedgeRegistry)registry).addConfiguration(arg_0, arg_1));
            return registry;
        }
    }
}

