/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.hedge.internal;

import io.github.resilience4j.core.metrics.FixedSizeSlidingWindowMetrics;
import io.github.resilience4j.core.metrics.Metrics;
import io.github.resilience4j.hedge.event.HedgeEvent;
import io.github.resilience4j.hedge.internal.HedgeDurationSupplier;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class AverageDurationSupplier
implements HedgeDurationSupplier {
    final boolean shouldUseFactorAsPercentage;
    final boolean shouldMeasureErrors;
    final int factor;
    final FixedSizeSlidingWindowMetrics metrics;

    public AverageDurationSupplier(boolean shouldUseFactorAsPercentage, int factor, boolean shouldMeasureErrors, int windowSize) {
        this.shouldUseFactorAsPercentage = shouldUseFactorAsPercentage;
        this.factor = factor;
        this.shouldMeasureErrors = shouldMeasureErrors;
        this.metrics = new FixedSizeSlidingWindowMetrics(windowSize);
    }

    @Override
    public Duration get() {
        Duration result = this.factor == 0 ? this.getAverageResponseTime() : (this.shouldUseFactorAsPercentage ? this.getAverageResponseTime().multipliedBy(this.factor).dividedBy(100L) : this.getAverageResponseTime().plus(Duration.ofMillis(this.factor)));
        return result;
    }

    private Duration getAverageResponseTime() {
        return this.metrics.getSnapshot().getAverageDuration();
    }

    @Override
    public void accept(HedgeEvent.Type type, Duration duration) {
        switch (type) {
            case PRIMARY_SUCCESS: {
                this.metrics.record(duration.toNanos(), TimeUnit.NANOSECONDS, Metrics.Outcome.SUCCESS);
                break;
            }
            case PRIMARY_FAILURE: {
                if (!this.shouldMeasureErrors) break;
                this.metrics.record(duration.toNanos(), TimeUnit.NANOSECONDS, Metrics.Outcome.ERROR);
                break;
            }
        }
    }

    public boolean shouldUseFactorAsPercentage() {
        return this.shouldUseFactorAsPercentage;
    }

    public boolean shouldMeasureErrors() {
        return this.shouldMeasureErrors;
    }

    public int getFactor() {
        return this.factor;
    }
}

