/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.hedge.internal;

import io.github.resilience4j.hedge.HedgeConfig;
import io.github.resilience4j.hedge.event.HedgeEvent;
import io.github.resilience4j.hedge.internal.AverageDurationSupplier;
import io.github.resilience4j.hedge.internal.PreconfiguredDurationSupplier;
import java.time.Duration;
import java.util.function.Supplier;

public interface HedgeDurationSupplier
extends Supplier<Duration> {
    public static HedgeDurationSupplier fromConfig(HedgeConfig config) {
        if (config.getDurationSupplier() == HedgeConfig.HedgeDurationSupplierType.PRECONFIGURED) {
            return HedgeDurationSupplier.ofPreconfigured(config.getCutoff());
        }
        return HedgeDurationSupplier.ofAveragePlus(config.isShouldUseFactorAsPercentage(), config.getHedgeTimeFactor(), config.isShouldMeasureErrors(), config.getWindowSize());
    }

    public static HedgeDurationSupplier ofAveragePlus(boolean shouldUseFactorAsPercentage, int factor, boolean shouldMeasureErrors, int windowSize) {
        return new AverageDurationSupplier(shouldUseFactorAsPercentage, factor, shouldMeasureErrors, windowSize);
    }

    public static HedgeDurationSupplier ofPreconfigured(Duration cutoff) {
        return new PreconfiguredDurationSupplier(cutoff);
    }

    public void accept(HedgeEvent.Type var1, Duration var2);
}

