/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.hedge;

import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.hedge.HedgeConfig;
import io.github.resilience4j.hedge.event.HedgeEvent;
import io.github.resilience4j.hedge.event.HedgeOnPrimaryFailureEvent;
import io.github.resilience4j.hedge.event.HedgeOnPrimarySuccessEvent;
import io.github.resilience4j.hedge.event.HedgeOnSecondaryFailureEvent;
import io.github.resilience4j.hedge.event.HedgeOnSecondarySuccessEvent;
import io.github.resilience4j.hedge.internal.HedgeDurationSupplier;
import io.github.resilience4j.hedge.internal.HedgeImpl;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public interface Hedge {
    public static final String DEFAULT_NAME = "UNDEFINED";

    public static Hedge ofDefaults() {
        return new HedgeImpl(DEFAULT_NAME, HedgeConfig.ofDefaults());
    }

    public static Hedge ofDefaults(String name) {
        return new HedgeImpl(name, HedgeConfig.ofDefaults());
    }

    public static Hedge of(HedgeConfig hedgeConfig) {
        return Hedge.of(DEFAULT_NAME, hedgeConfig);
    }

    public static Hedge of(String name, HedgeConfig hedgeConfig) {
        return new HedgeImpl(name, hedgeConfig);
    }

    public static Hedge of(String name, HedgeConfig hedgeConfig, Map<String, String> tags) {
        return new HedgeImpl(name, hedgeConfig, tags);
    }

    public static Hedge of(Duration hedgeDuration) {
        HedgeConfig hedgeConfig = new HedgeConfig.Builder().preconfiguredDuration(hedgeDuration).build();
        return new HedgeImpl(DEFAULT_NAME, hedgeConfig);
    }

    public <T> CompletableFuture<T> submit(Callable<T> var1, ExecutorService var2);

    public String getName();

    public Map<String, String> getTags();

    public HedgeConfig getHedgeConfig();

    public <T, F extends CompletionStage<T>> Supplier<CompletionStage<T>> decorateCompletionStage(Supplier<F> var1);

    public Metrics getMetrics();

    public EventPublisher getEventPublisher();

    public HedgeDurationSupplier getDurationSupplier();

    public Duration getDuration();

    public void onPrimarySuccess(Duration var1);

    public void onSecondarySuccess(Duration var1);

    public void onPrimaryFailure(Duration var1, Throwable var2);

    public void onSecondaryFailure(Duration var1, Throwable var2);

    public static interface EventPublisher
    extends io.github.resilience4j.core.EventPublisher<HedgeEvent> {
        public EventPublisher onPrimarySuccess(EventConsumer<HedgeOnPrimarySuccessEvent> var1);

        public EventPublisher onPrimaryFailure(EventConsumer<HedgeOnPrimaryFailureEvent> var1);

        public EventPublisher onSecondarySuccess(EventConsumer<HedgeOnSecondarySuccessEvent> var1);

        public EventPublisher onSecondaryFailure(EventConsumer<HedgeOnSecondaryFailureEvent> var1);
    }

    public static interface Metrics {
        public Duration getCurrentHedgeDelay();

        public long getPrimarySuccessCount();

        public long getSecondarySuccessCount();

        public long getPrimaryFailureCount();

        public long getSecondaryFailureCount();

        public int getSecondaryPoolActiveCount();
    }
}

