/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.common.bulkhead.configuration;

import java.time.Duration;

public class ThreadPoolProperties {
    private int maxThreadPoolSize;
    private int coreThreadPoolSize;
    private int queueCapacity;
    private Duration keepAliveDuration;

    public int getMaxThreadPoolSize() {
        return this.maxThreadPoolSize;
    }

    public ThreadPoolProperties setMaxThreadPoolSize(int maxThreadPoolSize) {
        this.maxThreadPoolSize = maxThreadPoolSize;
        return this;
    }

    public int getCoreThreadPoolSize() {
        return this.coreThreadPoolSize;
    }

    public ThreadPoolProperties setCoreThreadPoolSize(int coreThreadPoolSize) {
        this.coreThreadPoolSize = coreThreadPoolSize;
        return this;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public ThreadPoolProperties setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
        return this;
    }

    public long getKeepAliveTime() {
        if (this.keepAliveDuration != null) {
            return this.keepAliveDuration.toMillis();
        }
        return 20L;
    }

    public ThreadPoolProperties setKeepAliveTime(long keepAliveTime) {
        this.keepAliveDuration = Duration.ofMillis(keepAliveTime);
        return this;
    }

    public Duration getKeepAliveDuration() {
        return this.keepAliveDuration;
    }

    public ThreadPoolProperties setKeepAliveDuration(Duration keepAliveDuration) {
        this.keepAliveDuration = keepAliveDuration;
        return this;
    }
}

