/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.feign;

import feign.InvocationHandlerFactory;
import feign.Target;
import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.feign.DefaultFallbackHandler;
import io.github.resilience4j.feign.FallbackDecorator;
import io.github.resilience4j.feign.FallbackFactory;
import io.github.resilience4j.feign.FeignDecorator;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.retry.Retry;
import io.vavr.CheckedFunction1;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class FeignDecorators
implements FeignDecorator {
    private final List<FeignDecorator> decorators;

    private FeignDecorators(List<FeignDecorator> decorators) {
        this.decorators = decorators;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public CheckedFunction1<Object[], Object> decorate(CheckedFunction1<Object[], Object> fn, Method method, InvocationHandlerFactory.MethodHandler methodHandler, Target<?> target) {
        CheckedFunction1<Object[], Object> decoratedFn = fn;
        for (FeignDecorator decorator : this.decorators) {
            decoratedFn = decorator.decorate(decoratedFn, method, methodHandler, target);
        }
        return decoratedFn;
    }

    public static final class Builder {
        private final List<FeignDecorator> decorators = new ArrayList<FeignDecorator>();

        public Builder withRetry(Retry retry) {
            this.addFeignDecorator(fn -> Retry.decorateCheckedFunction((Retry)retry, (CheckedFunction1)fn));
            return this;
        }

        public Builder withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.addFeignDecorator(fn -> CircuitBreaker.decorateCheckedFunction((CircuitBreaker)circuitBreaker, (CheckedFunction1)fn));
            return this;
        }

        public Builder withRateLimiter(RateLimiter rateLimiter) {
            this.addFeignDecorator(fn -> RateLimiter.decorateCheckedFunction((RateLimiter)rateLimiter, (CheckedFunction1)fn));
            return this;
        }

        public Builder withFallback(Object fallback) {
            this.decorators.add(new FallbackDecorator<Object>(new DefaultFallbackHandler<Object>(fallback)));
            return this;
        }

        public Builder withFallbackFactory(Function<Exception, ?> fallbackFactory) {
            this.decorators.add(new FallbackDecorator(new FallbackFactory(fallbackFactory)));
            return this;
        }

        public Builder withFallback(Object fallback, Class<? extends Exception> filter) {
            this.decorators.add(new FallbackDecorator<Object>(new DefaultFallbackHandler<Object>(fallback), filter));
            return this;
        }

        public Builder withFallbackFactory(Function<Exception, ?> fallbackFactory, Class<? extends Exception> filter) {
            this.decorators.add(new FallbackDecorator(new FallbackFactory(fallbackFactory), filter));
            return this;
        }

        public Builder withFallback(Object fallback, Predicate<Exception> filter) {
            this.decorators.add(new FallbackDecorator<Object>(new DefaultFallbackHandler<Object>(fallback), filter));
            return this;
        }

        public Builder withFallbackFactory(Function<Exception, ?> fallbackFactory, Predicate<Exception> filter) {
            this.decorators.add(new FallbackDecorator(new FallbackFactory(fallbackFactory), filter));
            return this;
        }

        public Builder withBulkhead(Bulkhead bulkhead) {
            this.addFeignDecorator(fn -> Bulkhead.decorateCheckedFunction((Bulkhead)bulkhead, (CheckedFunction1)fn));
            return this;
        }

        private void addFeignDecorator(UnaryOperator<CheckedFunction1<Object[], Object>> decorator) {
            this.decorators.add((fn, m, mh, t) -> {
                if (m.isDefault()) {
                    return fn;
                }
                return (CheckedFunction1)decorator.apply(fn);
            });
        }

        public FeignDecorators build() {
            return new FeignDecorators(this.decorators);
        }
    }
}

