/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.feign;

import io.github.resilience4j.feign.FallbackHandler;
import io.vavr.CheckedFunction1;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.function.Function;
import java.util.function.Predicate;

class FallbackFactory<T>
implements FallbackHandler<T> {
    private final Function<Exception, T> fallbackSupplier;

    FallbackFactory(Function<Exception, T> fallbackSupplier) {
        this.fallbackSupplier = fallbackSupplier;
    }

    @Override
    public CheckedFunction1<Object[], Object> decorate(CheckedFunction1<Object[], Object> invocationCall, Method method, Predicate<Exception> filter) {
        return (CheckedFunction1 & Serializable)args -> {
            try {
                return invocationCall.apply(args);
            }
            catch (Exception exception) {
                if (filter.test(exception)) {
                    T fallbackInstance = this.fallbackSupplier.apply(exception);
                    this.validateFallback(fallbackInstance, method);
                    Method fallbackMethod = this.getFallbackMethod(fallbackInstance, method);
                    return fallbackMethod.invoke(fallbackInstance, args);
                }
                throw exception;
            }
        };
    }
}

