/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.feign;

import io.github.resilience4j.feign.FallbackHandler;
import io.vavr.CheckedFunction1;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.function.Predicate;

class DefaultFallbackHandler<T>
implements FallbackHandler<T> {
    private final T fallback;

    DefaultFallbackHandler(T fallback) {
        this.fallback = fallback;
    }

    @Override
    public CheckedFunction1<Object[], Object> decorate(CheckedFunction1<Object[], Object> invocationCall, Method method, Predicate<Exception> filter) {
        this.validateFallback(this.fallback, method);
        Method fallbackMethod = this.getFallbackMethod(this.fallback, method);
        return (CheckedFunction1 & Serializable)args -> {
            try {
                return invocationCall.apply(args);
            }
            catch (Exception exception) {
                if (filter.test(exception)) {
                    return fallbackMethod.invoke(this.fallback, args);
                }
                throw exception;
            }
        };
    }
}

