/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.feign;

import feign.InvocationHandlerFactory;
import feign.Target;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.feign.FallbackDecorator;
import io.github.resilience4j.feign.FeignDecorator;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.vavr.CheckedFunction1;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class FeignDecorators
implements FeignDecorator {
    private final List<FeignDecorator> decorators;

    private FeignDecorators(List<FeignDecorator> decorators) {
        this.decorators = decorators;
    }

    @Override
    public CheckedFunction1<Object[], Object> decorate(CheckedFunction1<Object[], Object> fn, Method method, InvocationHandlerFactory.MethodHandler methodHandler, Target<?> target) {
        CheckedFunction1<Object[], Object> decoratedFn = fn;
        for (FeignDecorator decorator : this.decorators) {
            decoratedFn = decorator.decorate(decoratedFn, method, methodHandler, target);
        }
        return decoratedFn;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final List<FeignDecorator> decorators = new ArrayList<FeignDecorator>();

        public Builder withCircuitBreaker(CircuitBreaker circuitBreaker) {
            this.decorators.add((fn, m, mh, t) -> CircuitBreaker.decorateCheckedFunction((CircuitBreaker)circuitBreaker, (CheckedFunction1)fn));
            return this;
        }

        public Builder withRateLimiter(RateLimiter rateLimiter) {
            this.decorators.add((fn, m, mh, t) -> RateLimiter.decorateCheckedFunction((RateLimiter)rateLimiter, (CheckedFunction1)fn));
            return this;
        }

        public Builder withFallback(Object fallback) {
            this.decorators.add(new FallbackDecorator<Object>(fallback));
            return this;
        }

        public Builder withFallback(Object fallback, Class<? extends Exception> filter) {
            this.decorators.add(new FallbackDecorator<Object>(fallback, filter));
            return this;
        }

        public Builder withFallback(Object fallback, Predicate<Exception> filter) {
            this.decorators.add(new FallbackDecorator<Object>(fallback, filter));
            return this;
        }

        public FeignDecorators build() {
            return new FeignDecorators(this.decorators);
        }
    }
}

